% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_PRE.R
\name{calc_PRE}
\alias{calc_PRE}
\title{Calculate PRE from Cohen's f, f_squared, or partial correlation}
\usage{
calc_PRE(f = NULL, f_squared = NULL, r_p = NULL)
}
\arguments{
\item{f}{Cohen's f. Cohen (1988) suggested >=0.1, >=0.25, and >=0.40 as cut-off values of f for small,
medium, and large effect sizes, respectively.}

\item{f_squared}{Cohen's f_squared. Cohen (1988) suggested >=0.02, >=0.15, and >=0.35 as cut-off values of f for small,
medium, and large effect sizes, respectively.}

\item{r_p}{Partial correlation.}
}
\value{
A list including PRE, r_p (partial correlation), Cohen's f_squared, and f.
}
\description{
Calculate PRE from Cohen's f, f_squared, or partial correlation
}
\examples{
calc_PRE(f = 0.1)
calc_PRE(f_squared = 0.02)
calc_PRE(r_p = 0.2)
}
\references{
Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.). Routledge.
}
