% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WarpSin.r
\docType{class}
\name{Warp}
\alias{Warp}
\title{The 'Warp' class object}
\format{
\code{\link{R6Class}} object.
}
\value{
an  \code{\link{R6Class}} object which can be used for doing interpolation using reproducing kernel Hilbert space.
}
\description{
This class provide the warping method which can be used to warp the original signal to sinusoidal like signal.
}
\section{Methods}{

\describe{
  \item{\code{warpsin(len ,lop,p0,eps)}}{This method is used to warp the initial interpolation into a sinusoidal shape.}   
  \item{\code{slowWarp(lens,peod,eps)}}{This method is used to find the optimised initial hyper parameters for the sigmoid basis function for each ode states.}
  \item{\code{ warpLossLen(par,lam,p0,eps)}}{This method is used to implement the loss function for warping. It is called by the 'warpSin' function.} }
}

\author{
Mu Niu, \email{mu.niu@glasgow.ac.uk}
}
\keyword{data}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{y}}{matrix(of size n_s*n_o) containing observation.}

\item{\code{t}}{vector(of length n_o) containing time points for observation.}

\item{\code{b}}{vector(of length n_o) containing coefficients of kernel or basis functions.}

\item{\code{lambda}}{scalar containing the weighting parameter for penalising the length of warped time span.}

\item{\code{ker}}{kernel class object containing sigmoid basis function.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Warp$new()}}
\item \href{#method-greet}{\code{Warp$greet()}}
\item \href{#method-showker}{\code{Warp$showker()}}
\item \href{#method-warpLoss}{\code{Warp$warpLoss()}}
\item \href{#method-warpLossLen}{\code{Warp$warpLossLen()}}
\item \href{#method-warpSin}{\code{Warp$warpSin()}}
\item \href{#method-slowWarp}{\code{Warp$slowWarp()}}
\item \href{#method-clone}{\code{Warp$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$new(y = NULL, t = NULL, b = NULL, lambda = NULL, ker = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-greet"></a>}}
\if{latex}{\out{\hypertarget{method-greet}{}}}
\subsection{Method \code{greet()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$greet()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-showker"></a>}}
\if{latex}{\out{\hypertarget{method-showker}{}}}
\subsection{Method \code{showker()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$showker()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-warpLoss"></a>}}
\if{latex}{\out{\hypertarget{method-warpLoss}{}}}
\subsection{Method \code{warpLoss()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$warpLoss(par, len, p0, eps)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-warpLossLen"></a>}}
\if{latex}{\out{\hypertarget{method-warpLossLen}{}}}
\subsection{Method \code{warpLossLen()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$warpLossLen(par, lam, p0, eps)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-warpSin"></a>}}
\if{latex}{\out{\hypertarget{method-warpSin}{}}}
\subsection{Method \code{warpSin()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$warpSin(len, lop, p0, eps)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slowWarp"></a>}}
\if{latex}{\out{\hypertarget{method-slowWarp}{}}}
\subsection{Method \code{slowWarp()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$slowWarp(lens, p0, eps)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Warp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
