% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{cancer}
\alias{cancer}
\title{Microarray data set for breast cancer}
\format{a list of two objects: dataframe with 133 observations of 26 features and
factors indicating whether each sample (out of 133) is of type "not" or type "pcr"}
\usage{
data(cancer)
}
\description{
% This gene expression data set is freely available, coming from the Hess
\emph{et al}'s paper. It concerns one hundred thirty-three patients with
stage I--III breast cancer.  Patients were treated with chemotherapy prior
to surgery. Patient response to the treatment can be classified as either a
pathologic complete response (pCR) or residual disease (not-pCR). Hess
\emph{et al} developed and tested a reliable multigene predictor for
treatment response on this data set, composed by a set of 26 genes having a
high predictive value.
}
\details{
The dataset splits into 2 parts (pCR and not pCR), on which network
inference algorithms should be applied independently or in the multitask
framework: only individuals from the same classes should be consider as
independent and identically distributed.
}
\references{
% K.R. Hess, K. Anderson, W.F. Symmans, V. Valero, N. Ibrahim,
J.A. Mejia, D. Booser, R.L. Theriault, U.  Buzdar, P.J. Dempsey, R. Rouzier,
N. Sneige, J.S. Ross, T. Vidaurre, H.L. Gomez, G.N. Hortobagyi, and L.
Pustzai (2006). Pharmacogenomic predictor of sensitivity to preoperative
chemotherapy with Paclitaxel and Fluorouracil, Doxorubicin, and
Cyclophosphamide in breast cancer, \emph{Journal of Clinical Oncology}, vol.
24(26), pp. 4236--4244.
}
\keyword{datasets}
