/*
 * Decompiled with CFR 0.152.
 */
package antlr;

class CharQueue {
    private char[] buffer;
    private int sizeLessOne;
    private int offset;
    protected int nbrEntries;

    public CharQueue(int n) {
        int n2 = 2;
        while (n2 < n) {
            n2 *= 2;
        }
        this.init(n2);
    }

    public final void append(char c) {
        if (this.nbrEntries == this.buffer.length) {
            this.expand();
        }
        this.buffer[this.offset + this.nbrEntries & this.sizeLessOne] = c;
        ++this.nbrEntries;
    }

    public final char elementAt(int n) {
        return this.buffer[this.offset + n & this.sizeLessOne];
    }

    private final void expand() {
        char[] cArray = new char[this.buffer.length * 2];
        int n = 0;
        while (n < this.buffer.length) {
            cArray[n] = this.elementAt(n);
            ++n;
        }
        this.buffer = cArray;
        this.sizeLessOne = this.buffer.length - 1;
        this.offset = 0;
    }

    private final void init(int n) {
        this.buffer = new char[n];
        this.sizeLessOne = n - 1;
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void removeFirst() {
        this.offset = this.offset + 1 & this.sizeLessOne;
        --this.nbrEntries;
    }
}

