/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import antlr.collections.AST;
import java.lang.reflect.Array;
import org.omegahat.Environment.DataStructures.Addable;
import org.omegahat.Environment.DataStructures.Divisable;
import org.omegahat.Environment.DataStructures.MathOperable;
import org.omegahat.Environment.DataStructures.Multiplicable;
import org.omegahat.Environment.DataStructures.Subtractable;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.NumberExpression;
import org.omegahat.Environment.Parser.Parse.OperatorExpression;

public class MathExpression
extends OperatorExpression {
    public MathExpression(int n, AST aST) {
        this.operator(n);
        AST aST2 = aST.getFirstChild();
        this.element(aST2, 0);
        this.element(aST2.getNextSibling(), 1);
    }

    public MathExpression(Object object, Object object2, int n) {
        super(object, object2, n);
    }

    public Object arrayOperation(Object object, Object object2) {
        Object object3 = object;
        boolean bl = object.getClass().isArray();
        boolean bl2 = object2.getClass().isArray();
        object3 = bl ? object : object2;
        Class<?> clazz = object3.getClass().getComponentType();
        int n = bl ? Array.getLength(object) : 1;
        int n2 = object2.getClass().isArray() ? Array.getLength(object2) : 1;
        int n3 = Math.max(n, n2);
        Object object4 = Array.newInstance(clazz, n3);
        Object[] objectArray = new Object[2];
        int n4 = 0;
        while (n4 < n3) {
            objectArray[0] = bl ? Array.get(object, n4 % n) : object;
            objectArray[1] = bl2 ? Array.get(object2, n4 % n2) : object2;
            Object object5 = this.numericComputation(objectArray);
            Array.set(object4, n4, object5);
            ++n4;
        }
        return object4;
    }

    public double computeNumeric(double[] dArray) {
        switch (this.operator()) {
            case 136: {
                dArray[0] = dArray[0] + dArray[1];
                break;
            }
            case 137: {
                dArray[0] = dArray[0] - dArray[1];
                break;
            }
            case 74: {
                dArray[0] = dArray[0] * dArray[1];
                break;
            }
            case 138: {
                dArray[0] = dArray[0] / dArray[1];
                break;
            }
            case 141: {
                dArray[0] = dArray[0] % dArray[1];
                break;
            }
            case 140: {
                dArray[0] = Math.pow(dArray[0], dArray[1]);
                break;
            }
        }
        return dArray[0];
    }

    public Object doSpecialInterface(MathOperable mathOperable, Object object) {
        Object object2 = null;
        switch (this.operator()) {
            case 136: {
                if (mathOperable instanceof Addable) {
                    object2 = ((Addable)mathOperable).addValue(object, false);
                    break;
                }
                return null;
            }
            case 137: {
                if (mathOperable instanceof Subtractable) {
                    object2 = ((Subtractable)((Object)mathOperable)).subtractValue(object, false);
                    break;
                }
                return null;
            }
            case 74: {
                if (mathOperable instanceof Multiplicable) {
                    object2 = ((Multiplicable)((Object)mathOperable)).multiplyValue(object, false);
                    break;
                }
                return null;
            }
            case 138: {
                if (mathOperable instanceof Divisable) {
                    object2 = ((Divisable)((Object)mathOperable)).divideValue(object, false);
                    break;
                }
                return null;
            }
        }
        return object2;
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        Object object = null;
        Object object2 = null;
        Object[] objectArray = new Object[this.els.length];
        int n = 0;
        while (n < this.els.length) {
            if (this.element(n) instanceof ExpressionInt) {
                object2 = ((ExpressionInt)this.element(n)).eval(evaluator);
            } else if (this.isNumber(this.element(n)) || this.element(n) instanceof String) {
                object2 = this.element(n);
            }
            objectArray[n] = object2;
            ++n;
        }
        object = this.operate(objectArray);
        return object;
    }

    public Object numericComputation(Object[] objectArray) {
        double[] dArray = new double[2];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = NumberExpression.asNumber(objectArray[n]);
            ++n;
        }
        dArray[0] = this.computeNumeric(dArray);
        Object object = this.toNumber(dArray[0], objectArray);
        return object;
    }

    public Object operate(Object[] objectArray) throws Exception {
        if (objectArray == null || objectArray.length != 2) {
            throw new Exception();
        }
        Object object = null;
        if ((objectArray[0] instanceof String || objectArray[1] instanceof String) && this.operator() == 136) {
            object = String.valueOf(objectArray[0].toString()) + objectArray[1].toString();
        } else if (objectArray[0] instanceof MathOperable) {
            object = this.doSpecialInterface((MathOperable)objectArray[0], objectArray[1]);
        } else if (objectArray[0].getClass().isArray() || objectArray[1].getClass().isArray()) {
            object = this.arrayOperation(objectArray[0], objectArray[1]);
        } else {
            double[] dArray = new double[2];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = NumberExpression.asNumber(objectArray[n]);
                ++n;
            }
            dArray[0] = this.computeNumeric(dArray);
            object = this.toNumber(dArray[0], objectArray);
        }
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.element(0));
        stringBuffer.append(" " + this.separator() + " ");
        stringBuffer.append(this.element(1));
        return stringBuffer.toString();
    }
}

