/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUITools.MethodViewer;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MethodTreeModel
implements TreeModel {
    protected static final int CONSTRUCTORS = 0;
    protected static final int FIELDS = 1;
    protected static final int METHODS = 2;
    public static String[] TypeNames = new String[]{"Constructors", "Fields", "Methods"};
    protected boolean nonPublic = true;
    private boolean useMethods;
    private boolean useFields;
    private boolean useConstructors;
    protected Class source;

    public MethodTreeModel(Class clazz) {
        this.source(clazz);
    }

    public MethodTreeModel(Class clazz, boolean bl) {
        this.source(clazz);
        this.nonPublic(bl);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public Constructor[] constructors() {
        return this.source().getConstructors();
    }

    public Object copyTo(Object object, Object object2) {
        if (object2 == null) {
            object2 = object;
        } else {
            int n = Array.getLength(object2);
            int n2 = Array.getLength(object);
            Object object3 = Array.newInstance(object.getClass().getComponentType(), n + n2);
            System.arraycopy(object2, 0, object3, 0, n);
            System.arraycopy(object, 0, object3, n, n2);
            object2 = object3;
        }
        return object2;
    }

    public Field[] fields() {
        return this.source().getFields();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getChild(Object object, int n) {
        Object object2 = null;
        if (object instanceof Class) {
            switch (n) {
                case 0: {
                    return new Integer(1);
                }
                case 1: {
                    return new Integer(0);
                }
                case 2: {
                    return new Integer(2);
                }
                default: {
                    return object2;
                }
            }
        }
        if (!(object instanceof Integer)) return object2;
        int n2 = (Integer)object;
        if (this.nonPublic()) {
            object2 = this.getElements(n2);
            return Array.get(object2, n);
        }
        switch (n2) {
            case 0: {
                object2 = this.constructors()[n];
                break;
            }
            case 2: {
                object2 = this.methods()[n];
                break;
            }
            case 1: {
                object2 = this.fields()[n];
            }
        }
        return object2;
    }

    public int getChildCount(Object object) {
        int n = 0;
        if (object instanceof Class) {
            n = 3;
        } else if (object instanceof Integer) {
            int n2 = (Integer)object;
            Object var4_4 = null;
            if (this.nonPublic()) {
                n = Array.getLength(this.getElements(n2));
            } else {
                switch (n2) {
                    case 0: {
                        n = this.constructors().length;
                        break;
                    }
                    case 2: {
                        n = this.methods().length;
                        break;
                    }
                    case 1: {
                        n = this.fields().length;
                        break;
                    }
                }
            }
        }
        return n;
    }

    public Object getElements(int n) {
        Class clazz = this.source();
        AccessibleObject[] accessibleObjectArray = null;
        Object object = null;
        while (clazz != null) {
            switch (n) {
                case 0: {
                    accessibleObjectArray = clazz.getDeclaredConstructors();
                    break;
                }
                case 2: {
                    accessibleObjectArray = clazz.getDeclaredMethods();
                    break;
                }
                case 1: {
                    accessibleObjectArray = clazz.getDeclaredFields();
                    break;
                }
            }
            object = this.copyTo(accessibleObjectArray, object);
            clazz = n == 0 ? null : clazz.getSuperclass();
        }
        return object;
    }

    public int getIndexOfChild(Object object, Object object2) {
        return 0;
    }

    public Object getRoot() {
        return this.source();
    }

    public boolean isLeaf(Object object) {
        boolean bl = true;
        if (object instanceof Class) {
            bl = false;
        } else if (object instanceof String) {
            bl = false;
        } else if (object instanceof Integer) {
            bl = false;
        }
        return bl;
    }

    public Method[] methods() {
        return this.source().getMethods();
    }

    public boolean nonPublic() {
        return this.nonPublic;
    }

    public boolean nonPublic(boolean bl) {
        this.nonPublic = bl;
        return this.nonPublic();
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public Class source() {
        return this.source;
    }

    public Class source(Class clazz) {
        this.source = clazz;
        return this.source();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }
}

