% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_support.R
\name{predict.ps2dglm}
\alias{predict.ps2dglm}
\title{Predict function for \code{ps2DGLM}}
\usage{
\method{predict}{ps2dglm}(object, ..., XY, type = "mu")
}
\arguments{
\item{object}{an object using \code{ps2DGLM}.}

\item{...}{other parameters.}

\item{XY}{a matrix of arbitrary (\code{x}, \code{y}) locations for
desired prediction.}

\item{type}{the mean value \code{type = "mu"} (default) or linear predictor
\code{type = "eta"}.}
}
\value{
\item{pred}{the estimated mean (inverse link function) (default)
or the linear predictor prediction with \code{type =
"eta"}, for arbitary (x, y) locations in \code{XY}.}
}
\description{
Prediction function which returns both linear
predictor and inverse link predictions at arbitrary (x, y) data locations
(using \code{ps2DGLM} with \code{class ps2dglm}).
}
\examples{
library(fields)
library(JOPS)
# Extract data
library(rpart)
Kyphosis <- kyphosis$Kyphosis
Age <- kyphosis$Age
Start <- kyphosis$Start
y <- 1 * (Kyphosis == "present") # make y 0/1
fit <- ps2DGLM(
  Data = cbind(Start, Age, y),
  Pars = rbind(c(1, 18, 10, 3, .1, 2), c(1, 206, 10, 3, .1, 2)),
  family = "binomial", link = "logit")
predict(fit, XY = cbind(Start, Age)[1:5,])
}
\references{
Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
