/*
 * Decompiled with CFR 0.152.
 */
package j4r.net.server;

import j4r.app.AbstractGenericEngine;
import j4r.net.SocketWrapper;
import j4r.net.TCPSocketWrapper;
import j4r.net.server.ClientThread;
import j4r.net.server.ServerConfiguration;
import j4r.net.server.ServerTask;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractServer
extends AbstractGenericEngine
implements PropertyChangeListener {
    private final ArrayList<ClientThread> clientThreads;
    private final ArrayList<ClientThread> gcThreads;
    protected final List<CallReceiverThread> callReceiverThreads;
    protected final CallReceiverThread gcReceiverThread;
    protected final ConcurrentHashMap<ClientThread, InetAddress> whoIsWorkingForWho;
    protected final BackDoorThread backdoorThread;
    protected final boolean isCallerAJavaApplication;
    private final ServerConfiguration configuration;
    private List<PropertyChangeListener> listeners;

    protected AbstractServer(ServerConfiguration configuration, boolean isCallerAJavaApplication) throws Exception {
        this.configuration = configuration;
        this.isCallerAJavaApplication = isCallerAJavaApplication;
        this.clientThreads = new ArrayList();
        this.gcThreads = new ArrayList();
        this.whoIsWorkingForWho = new ConcurrentHashMap();
        this.callReceiverThreads = new ArrayList<CallReceiverThread>();
        try {
            List<ServerSocket> serverSockets = configuration.createServerSockets();
            int i = 1;
            for (ServerSocket ss : serverSockets) {
                CallReceiverThread crt = new CallReceiverThread(ss, i);
                this.callReceiverThreads.add(crt);
                int j = 1;
                while (j <= configuration.numberOfClientThreadsPerReceiver) {
                    this.clientThreads.add(this.createClientThread(crt, i * 1000 + j));
                    ++j;
                }
                ++i;
            }
            this.backdoorThread = new BackDoorThread(configuration.internalPorts[0]);
            ServerSocket gcServerSocket = new ServerSocket(configuration.internalPorts[1]);
            this.gcReceiverThread = new CallReceiverThread(gcServerSocket, 99);
            int j = 1;
            while (j <= configuration.numberOfClientThreadsPerReceiver) {
                this.gcThreads.add(this.createClientThread(this.gcReceiverThread, 99000 + j));
                ++j;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("Unable to initialize the server");
        }
        this.listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    }

    protected boolean checkSecurity(SocketWrapper clientSocket) {
        if (this.configuration.isLocal) {
            block6: {
                try {
                    Object obj = clientSocket.readObject();
                    int key = Integer.parseInt(obj.toString());
                    if (this.configuration.key != key) break block6;
                    clientSocket.writeObject((Object)ServerReply.SecurityChecked);
                    return true;
                }
                catch (Exception e) {
                    try {
                        clientSocket.writeObject(e);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return false;
                }
            }
            clientSocket.writeObject((Object)ServerReply.SecurityFailed);
            return false;
        }
        return true;
    }

    protected abstract ClientThread createClientThread(CallReceiverThread var1, int var2);

    protected void listenToClients() {
        for (ClientThread t : this.clientThreads) {
            t.start();
        }
        for (ClientThread t : this.gcThreads) {
            t.start();
        }
    }

    protected void startReceiverThread() throws ExecutionException, InterruptedException {
        this.listenToClients();
        for (CallReceiverThread t : this.callReceiverThreads) {
            t.start();
        }
        this.gcReceiverThread.start();
        System.out.println("Server started");
    }

    protected ServerConfiguration getConfiguration() {
        return this.configuration;
    }

    protected List<ClientThread> getClientThreads() {
        return this.clientThreads;
    }

    protected void closeAndRestartTheseThreads(Collection<ClientThread> connectionsToBeClosed) {
        for (ClientThread thread : connectionsToBeClosed) {
            try {
                thread.getSocket().close();
                thread.restartAction();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void firstTasksToDo() {
        this.addTask(new ServerTask(ServerTask.ServerTaskID.StartReceiverThread, this));
        if (this.configuration.isLocalServer()) {
            this.addTask(new ServerTask(ServerTask.ServerTaskID.CreateFileInfo, this));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent("Server event", propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("shutdownServer")) {
            this.requestShutdown();
        }
    }

    @Override
    public void requestShutdown() {
        for (CallReceiverThread t : this.callReceiverThreads) {
            t.shutdownCall = true;
            t.clientQueue.clear();
            try {
                try {
                    if (t.serverSocket != null) {
                        t.serverSocket.close();
                    }
                }
                catch (IOException e) {
                    t.interrupt();
                    try {
                        t.join(5000L);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    t.join(5000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                t.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.requestShutdown();
    }

    protected abstract void createFileInfoForLocalServer() throws IOException;

    class BackDoorThread
    extends Thread {
        final ServerSocket emergencySocket;
        final int port;

        BackDoorThread(int port) throws IOException {
            super("Back door thread");
            this.setDaemon(true);
            this.port = port;
            this.emergencySocket = new ServerSocket(port);
            this.start();
        }

        @Override
        public void run() {
            block18: while (true) {
                SocketWrapper clientSocket = null;
                try {
                    clientSocket = new TCPSocketWrapper(this.emergencySocket.accept(), false);
                    clientSocket.writeObject((Object)ServerReply.CallAccepted);
                    if (!AbstractServer.this.checkSecurity(clientSocket)) continue;
                    Object request = clientSocket.readObject();
                    if (request.toString().equals("emergencyShutdown")) {
                        System.exit(1);
                        continue;
                    }
                    if (request.toString().equals("softExit")) {
                        this.emergencySocket.close();
                        break;
                    }
                    try {
                        if (!request.toString().equals("interrupt")) continue;
                        InetAddress clientAddress = clientSocket.getInetAddress();
                        Iterator iterator = ((ConcurrentHashMap.KeySetView)AbstractServer.this.whoIsWorkingForWho.keySet()).iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block18;
                            ClientThread t = (ClientThread)iterator.next();
                            InetAddress clientOfThisTread = AbstractServer.this.whoIsWorkingForWho.get(t);
                            if (!clientOfThisTread.equals(clientAddress)) continue;
                            t.interrupt();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                finally {
                    try {
                        if (clientSocket == null || clientSocket.isClosed()) continue;
                        clientSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }

        protected void softExit() {
            try {
                Socket socket = new Socket(InetAddress.getLoopbackAddress(), this.port);
                TCPSocketWrapper socketWrapper = new TCPSocketWrapper(socket, false);
                socketWrapper.readObject();
                socketWrapper.writeObject("softExit");
                socketWrapper.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CallReceiverThread
    extends Thread {
        private boolean shutdownCall;
        final ServerSocket serverSocket;
        final LinkedBlockingQueue<SocketWrapper> clientQueue;
        final int id;

        private CallReceiverThread(ServerSocket serverSocket, int id) {
            this.serverSocket = serverSocket;
            this.id = id;
            this.clientQueue = new LinkedBlockingQueue();
            this.shutdownCall = false;
            this.setName("Answering call thread " + this.id);
        }

        @Override
        public void run() {
            try {
                try {
                    while (!this.shutdownCall) {
                        TCPSocketWrapper clientSocket = new TCPSocketWrapper(this.serverSocket.accept(), AbstractServer.this.isCallerAJavaApplication);
                        clientSocket.writeObject((Object)ServerReply.CallAccepted);
                        if (!AbstractServer.this.checkSecurity(clientSocket)) continue;
                        this.clientQueue.add(clientSocket);
                    }
                    System.out.println("Call receiver thread shut down");
                }
                catch (Exception e) {
                    if (!this.shutdownCall) {
                        e.printStackTrace();
                    }
                    try {
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static enum ServerReply {
        IAmBusyCallBackLater,
        CallAccepted,
        ClosingConnection,
        Done,
        SecurityChecked,
        SecurityFailed;

    }
}

