/*
 * Decompiled with CFR 0.152.
 */
package j4r.net.server;

import j4r.lang.codetranslator.REnvironment;
import j4r.net.SocketWrapper;
import j4r.net.TCPSocketWrapper;
import j4r.net.server.AbstractServer;
import j4r.net.server.BasicClient;
import j4r.net.server.ClientThread;
import j4r.net.server.ServerConfiguration;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class JavaLocalGatewayServer
extends AbstractServer {
    protected final REnvironment translator;
    protected final boolean shutdownOnClosedConnection;
    protected final REpiceaBackDoorCancellationThread backdoorThread;
    protected boolean bypassShutdownForTesting;

    public JavaLocalGatewayServer(ServerConfiguration servConf, REnvironment translator) throws Exception {
        this(servConf, translator, true);
    }

    @Override
    protected synchronized SocketWrapper getWaitingClients() throws InterruptedException {
        SocketWrapper socket = (SocketWrapper)this.clientQueue.take();
        return socket;
    }

    protected JavaLocalGatewayServer(ServerConfiguration servConf, REnvironment translator, boolean shutdownOnClosedConnection) throws Exception {
        super(servConf, false);
        this.translator = translator;
        this.shutdownOnClosedConnection = shutdownOnClosedConnection;
        this.backdoorThread = new REpiceaBackDoorCancellationThread(50000);
    }

    @Override
    protected ClientThread createClientThread(AbstractServer server, int id) {
        return new JavaGatewayClientThread(server, id);
    }

    @Override
    protected void shutdown(int shutdownCode) {
        if (this.backdoorThread.isAlive()) {
            this.backdoorThread.softExit();
        }
        if (this.bypassShutdownForTesting) {
            return;
        }
        super.shutdown(shutdownCode);
    }

    private class JavaGatewayClientThread
    extends ClientThread {
        protected JavaGatewayClientThread(AbstractServer caller, int workerID) {
            super(caller, workerID);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block7: do {
                        JavaLocalGatewayServer.this.firePropertyChange("status", null, "Waiting");
                        this.socketWrapper = this.caller.getWaitingClients();
                        InetAddress clientAddress = this.socketWrapper.getInetAddress();
                        JavaLocalGatewayServer.this.firePropertyChange("status", null, "Connected to client: " + clientAddress.getHostAddress());
                        while (!this.socketWrapper.isClosed()) {
                            try {
                                Object somethingInParticular = this.processRequest();
                                if (somethingInParticular != null) {
                                    if (somethingInParticular.equals((Object)BasicClient.ClientRequest.closeConnection) || somethingInParticular.equals(BasicClient.ClientRequest.closeConnection.name())) {
                                        this.socketWrapper.writeObject((Object)AbstractServer.ServerReply.ClosingConnection);
                                        this.closeSocket();
                                        this.caller.requestShutdown();
                                        continue block7;
                                    }
                                    this.socketWrapper.writeObject(somethingInParticular);
                                    continue;
                                }
                                this.socketWrapper.writeObject((Object)AbstractServer.ServerReply.RequestReceivedAndProcessed);
                            }
                            catch (Exception e) {
                                try {
                                    if (e instanceof IOException) {
                                        this.closeSocket();
                                        continue;
                                    }
                                    if (this.socketWrapper.isClosed()) continue;
                                    if (e instanceof InvocationTargetException) {
                                        this.socketWrapper.writeObject(new JavaGatewayException(((InvocationTargetException)e).getTargetException()));
                                        continue;
                                    }
                                    this.socketWrapper.writeObject(new JavaGatewayException((Throwable)e));
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    } while (!JavaLocalGatewayServer.this.shutdownOnClosedConnection);
                    this.caller.requestShutdown();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        @Override
        protected Object processRequest() throws Exception {
            Object crudeRequest = this.getSocket().readObject();
            if (crudeRequest instanceof BasicClient.ClientRequest) {
                return crudeRequest;
            }
            if (crudeRequest instanceof String) {
                String request = (String)crudeRequest;
                if (request.startsWith("time")) {
                    long startMillisec = Long.parseLong(request.substring(4));
                    long finalTime = System.currentTimeMillis();
                    double elapsedTime = finalTime - startMillisec;
                    System.out.println("Elapsed time single received packet:" + elapsedTime);
                }
                return JavaLocalGatewayServer.this.translator.processCode(request);
            }
            return null;
        }
    }

    final class JavaGatewayException
    extends Exception {
        final Throwable nestedException;

        JavaGatewayException(Throwable e) {
            super(e);
            this.nestedException = e;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getName()) + "_" + this.nestedException.toString();
        }
    }

    class REpiceaBackDoorCancellationThread
    extends Thread {
        private final ServerSocket emergencySocket;
        private final int port;

        REpiceaBackDoorCancellationThread(int port) throws IOException {
            super("Back door cancellation thread");
            this.port = port;
            this.emergencySocket = new ServerSocket(port);
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                SocketWrapper clientSocket = null;
                try {
                    clientSocket = new TCPSocketWrapper(this.emergencySocket.accept(), false);
                    clientSocket.writeObject((Object)AbstractServer.ServerReply.CallAccepted);
                    Object request = clientSocket.readObject();
                    if (request.toString().equals("emergencyShutdown")) {
                        System.exit(1);
                        continue;
                    }
                    if (!request.toString().equals("softExit")) continue;
                    this.emergencySocket.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    continue;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        if (clientSocket == null || clientSocket.isClosed()) continue;
                        clientSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }

        protected void softExit() {
            try {
                Socket socket = new Socket(InetAddress.getLoopbackAddress(), this.port);
                TCPSocketWrapper socketWrapper = new TCPSocketWrapper(socket, false);
                socketWrapper.readObject();
                socketWrapper.writeObject("softExit");
                socketWrapper.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

