% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{write_config}
\alias{write_config}
\title{Save a \code{config} object as files}
\usage{
write_config(
  cfg,
  config_path,
  transitions_path,
  parameters_path,
  weather_path,
  host_comm_path
)
}
\arguments{
\item{cfg}{A \code{config} object}

\item{config_path}{Path to the output YAML config file}

\item{transitions_path}{Path to output transitions csv}

\item{parameters_path}{Path to output parameters csv}

\item{weather_path}{Path to output weather csv}

\item{host_comm_path}{Path to output host_comm csv}
}
\value{
None, writes config components to disk
}
\description{
Write a \code{config} object as a YAML file, and write all dataframe
components (transitions, parameters, weather, host_comm) as csv files. All
paths must be explicitly specified as arguments. This function will not
allow overwriting files.
}
\examples{

\dontrun{
write_config(config_ex_1, 'cfg.yml', 'trans.csv', 'params.csv',
             'weather.csv', 'host_comm.csv')
}

}
