% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/york.R
\name{data2york}
\alias{data2york}
\alias{data2york.default}
\alias{data2york.UPb}
\alias{data2york.ArAr}
\alias{data2york.KCa}
\alias{data2york.PbPb}
\alias{data2york.PD}
\alias{data2york.UThHe}
\alias{data2york.ThU}
\title{Prepare geochronological data for York regression}
\usage{
data2york(x, ...)

\method{data2york}{default}(x, format = 1, ...)

\method{data2york}{UPb}(x, option = 1, ...)

\method{data2york}{ArAr}(x, inverse = TRUE, ...)

\method{data2york}{KCa}(x, inverse = FALSE, ...)

\method{data2york}{PbPb}(x, inverse = TRUE, ...)

\method{data2york}{PD}(x, exterr = FALSE, inverse = FALSE, ...)

\method{data2york}{UThHe}(x, ...)

\method{data2york}{ThU}(x, type = 2, generic = TRUE, ...)
}
\arguments{
\item{x}{a five or six column matrix OR an object of class
\code{UPb}, \code{PbPb}, \code{ArAr}, \code{ThU}, \code{UThHe},
or \code{PD} (which includes objects of class \code{RbSr},
\code{SmNd}, \code{LuHf} and \code{ReOs}), generated by the
\code{read.data(...)} function}

\item{...}{optional arguments}

\item{format}{one of

1. \code{X}, \code{s[X]}, \code{Y}, \code{s[Y]}, \code{rho}

where \code{rho} is the error correlation between \code{X} and
\code{Y}, or

2. \code{X/Z}, \code{s[X/Z]}, \code{Y/Z}, \code{s[Y/Z]},
\code{X/Y}, \code{s[X/Y]} for which the error correlations are
automatically computed from the redundancy of the three ratios.}

\item{option}{one of

\enumerate{

\item Wetherill concordia ratios: \code{X=7/5}, \code{sX=s[7/5]},
    \code{Y=6/8}, \code{sY=s[6/8]}, \code{rXY}.

\item Tera-Wasserburg ratios: \code{X=8/6}, \code{sX=s[8/6]},
    \code{Y=7/6}, \code{sY=s[7/6]}, \code{rho=rXY}.

\item \code{X=4/6}, \code{sX=s[4/6]}, \code{Y=8/6},
    \code{sY=s[8/6]}, \code{rho=rXY} (only valid if \code{format >
    3}).

\item \code{X=4/7}, \code{sX=s[4/7]}, \code{Y=5/7},
    \code{sY=s[5/7]}, \code{rho=rXY} (only valid if \code{format >
    3}).

}}

\item{inverse}{If \code{x} has class \code{ArAr} and
    \code{inverse=FALSE}, returns a table with columns
    \code{X=9/6}, \code{sX=s[9/6]}, \code{Y=0/6}, code{sY=s[0/6]},
    \code{rXY}

If \code{x} has class \code{ArAr} and \code{inverse=TRUE}, returns
    a table with columns \code{X=9/0}, \code{sX=s[9/0]},
    \code{Y=6/0}, code{sY=s[6/0]}, \code{rXY}

If \code{x} has class \code{PbPb} and
    \code{inverse=FALSE}, returns a table with columns
    \code{X=6/4}, \code{sX=s[6/4]}, \code{Y=7/4}, code{sY=s[7/4]},
    \code{rXY}

If \code{x} has class \code{PbPb} and \code{inverse=TRUE}, returns
    a table with columns \code{X=4/6}, \code{sX=s[4/6]},
    \code{Y=7/6}, \code{sY=s[7/6]}, \code{rXY}}

\item{exterr}{If \code{TRUE}, propagates the external uncertainties
(e.g. decay constants) into the output errors.}

\item{type}{Return `Rosholt' or `Osmond' ratios?

Rosholt (\code{type=1}) returns \code{X=8/2}, \code{sX=s[8/2]},
\code{Y=0/2}, \code{sY=s[0/2]}, \code{rXY}.

Osmond (\code{type=2}) returns \code{X=2/8}, \code{sX=s[2/8]},
\code{Y=0/8}, \code{sY=s[0/8]}, \code{rXY}.}

\item{generic}{If \code{TRUE}, uses the following column headers:
    \code{X}, \code{sX}, \code{Y}, \code{sY}, \code{rXY}.

If \code{FALSE} and \code{type=1}, uses \code{U238Th232},
    \code{errU238Th232}, \code{Th230Th232}, \code{errTh230Th232},
    \code{rho}

or if \code{FALSE} and \code{type=2}, uses \code{Th232U238},
    \code{errTh232U238}, \code{Th230U238}, \code{errTh230U238},
    \code{rho}.}
}
\value{
a five-column table that can be used as input for
    \code{\link{york}}-regression.
}
\description{
Takes geochronology data as input and produces a
five-column table as output, which can be used
for York regression.
}
\examples{
f <- system.file("RbSr1.csv",package="IsoplotR")
dat <- read.csv(f)
yorkdat <- data2york(dat)
fit <- york(yorkdat)
}
\seealso{
\code{\link{york}}
}
