% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.data}
\alias{read.data}
\alias{read.data.default}
\alias{read.data.matrix}
\title{Read geochronology data}
\usage{
read.data(x, ...)

\method{read.data}{default}(x, method = "U-Pb", format = 1, ...)

\method{read.data}{matrix}(x, method = "U-Pb", format = 1, ...)
}
\arguments{
\item{x}{a file name (\code{.csv} format) or matrix}

\item{...}{optional arguments to the \code{read.csv} function}

\item{method}{one of \code{'U-Pb'}, \code{'Ar-Ar'}, \code{'Rb-Sr'},
\code{'Sm-Nd'}, \code{'Re-Os'}, \code{'U-Th-He'},
\code{'fission tracks'}, \code{'cosmogenic nuclides'} or
\code{'other'}}

\item{format}{formatting option, depends on the value of
    \code{method}. If \code{method = 'U-Pb'}, then \code{format} is
    one of either:

\code{1}: 7/6, s[7/6], 6/8, s[6/8], 7/5, s[7/5]

If \code{method = 'Ar-Ar'}, then \code{format} is one of either:

\code{1}: 39/40, s[39/40], 36/40, s[36/40], 39/36, s[39/36]

\code{2}: 39, 39/40, s[39/40], 36/40, s[36/40], 39/36, s[39/36]}
}
\value{
an object of class \code{'UPb'}, \code{'ArAr'},
    \code{'RbSr'}, \code{'SmNd'}, \code{'ReOs'}, \code{'UThHe'},
    \code{'fission'}, \code{'cosmogenics'}, or \code{'other'}
}
\description{
Cast a \code{.csv} file or a matrix into one of \code{IsoplotR}'s
data classes
}
\examples{
# load one of the built-in .csv files:
data(examples)
concordia(examples$UPb)
}

