/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.stat.tdouble.Gamma;

public class DoubleDescriptive {
    protected DoubleDescriptive() {
    }

    public static double autoCorrelation(DoubleArrayList doubleArrayList, int n, double d, double d2) {
        int n2 = doubleArrayList.size();
        if (n >= n2) {
            throw new IllegalArgumentException("Lag is too large");
        }
        double[] dArray = doubleArrayList.elements();
        double d3 = 0.0;
        for (int i = n; i < n2; ++i) {
            d3 += (dArray[i] - d) * (dArray[i - n] - d);
        }
        return d3 / (double)(n2 - n) / d2;
    }

    protected static void checkRangeFromTo(int n, int n2, int n3) {
        if (n2 == n - 1) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= n3) {
            throw new IndexOutOfBoundsException("from: " + n + ", to: " + n2 + ", size=" + n3);
        }
    }

    public static double correlation(DoubleArrayList doubleArrayList, double d, DoubleArrayList doubleArrayList2, double d2) {
        return DoubleDescriptive.covariance(doubleArrayList, doubleArrayList2) / (d * d2);
    }

    public static double covariance(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList.size();
        if (n != doubleArrayList2.size() || n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double[] dArray2 = doubleArrayList2.elements();
        double d = dArray[0];
        double d2 = dArray2[0];
        double d3 = 0.0;
        for (int i = 1; i < n; ++i) {
            double d4 = dArray[i];
            double d5 = dArray2[i];
            d3 += (d4 - (d += d4) / (double)(i + 1)) * (d5 - d2 / (double)i);
            d2 += d5;
        }
        return d3 / (double)(n - 1);
    }

    private static double covariance2(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList.size();
        double d = DoubleDescriptive.mean(doubleArrayList);
        double d2 = DoubleDescriptive.mean(doubleArrayList2);
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = doubleArrayList.get(i);
            double d5 = doubleArrayList2.get(i);
            d3 += (d4 - d) * (d5 - d2);
        }
        return d3 / (double)(n - 1);
    }

    public static double durbinWatson(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        if (n < 2) {
            throw new IllegalArgumentException("data sequence must contain at least two values.");
        }
        double[] dArray = doubleArrayList.elements();
        double d = 0.0;
        double d2 = 0.0;
        d2 = dArray[0] * dArray[0];
        for (int i = 1; i < n; ++i) {
            double d3 = dArray[i] - dArray[i - 1];
            d += d3 * d3;
            d2 += dArray[i] * dArray[i];
        }
        return d / d2;
    }

    public static void frequencies(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, IntArrayList intArrayList) {
        doubleArrayList2.clear();
        if (intArrayList != null) {
            intArrayList.clear();
        }
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            int n3 = n2;
            while (++n2 < n && dArray[n2] == d) {
            }
            int n4 = n2 - n3;
            doubleArrayList2.add(d);
            if (intArrayList == null) continue;
            intArrayList.add(n4);
        }
    }

    public static double geometricMean(int n, double d) {
        return Math.exp(d / (double)n);
    }

    public static double geometricMean(DoubleArrayList doubleArrayList) {
        return DoubleDescriptive.geometricMean(doubleArrayList.size(), DoubleDescriptive.sumOfLogarithms(doubleArrayList, 0, doubleArrayList.size() - 1));
    }

    public static double harmonicMean(int n, double d) {
        return (double)n / d;
    }

    public static void incrementalUpdate(DoubleArrayList doubleArrayList, int n, int n2, double[] dArray) {
        DoubleDescriptive.checkRangeFromTo(n, n2, doubleArrayList.size());
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double[] dArray2 = doubleArrayList.elements();
        while (n <= n2) {
            double d5 = dArray2[n];
            d3 += d5;
            d4 += d5 * d5;
            if (d5 < d) {
                d = d5;
            }
            if (d5 > d2) {
                d2 = d5;
            }
            ++n;
        }
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
    }

    public static void incrementalUpdateSumsOfPowers(DoubleArrayList doubleArrayList, int n, int n2, int n3, int n4, double[] dArray) {
        int n5 = doubleArrayList.size();
        int n6 = n4 - n3;
        if (n > n5 || n6 + 1 > dArray.length) {
            throw new IllegalArgumentException();
        }
        if (n3 == 1) {
            if (n4 == 2) {
                double[] dArray2 = doubleArrayList.elements();
                double d = dArray[0];
                double d2 = dArray[1];
                int n7 = n - 1;
                while (++n7 <= n2) {
                    double d3 = dArray2[n7];
                    d += d3;
                    d2 += d3 * d3;
                }
                dArray[0] = dArray[0] + d;
                dArray[1] = dArray[1] + d2;
                return;
            }
            if (n4 == 3) {
                double[] dArray3 = doubleArrayList.elements();
                double d = dArray[0];
                double d4 = dArray[1];
                double d5 = dArray[2];
                int n8 = n - 1;
                while (++n8 <= n2) {
                    double d6 = dArray3[n8];
                    d += d6;
                    d4 += d6 * d6;
                    d5 += d6 * d6 * d6;
                }
                dArray[0] = dArray[0] + d;
                dArray[1] = dArray[1] + d4;
                dArray[2] = dArray[2] + d5;
                return;
            }
            if (n4 == 4) {
                double[] dArray4 = doubleArrayList.elements();
                double d = dArray[0];
                double d7 = dArray[1];
                double d8 = dArray[2];
                double d9 = dArray[3];
                int n9 = n - 1;
                while (++n9 <= n2) {
                    double d10 = dArray4[n9];
                    d += d10;
                    d7 += d10 * d10;
                    d8 += d10 * d10 * d10;
                    d9 += d10 * d10 * d10 * d10;
                }
                dArray[0] = dArray[0] + d;
                dArray[1] = dArray[1] + d7;
                dArray[2] = dArray[2] + d8;
                dArray[3] = dArray[3] + d9;
                return;
            }
        }
        if (n3 == n4 || n3 >= -1 && n4 <= 5) {
            for (int i = n3; i <= n4; ++i) {
                int n10 = i - n3;
                dArray[n10] = dArray[n10] + DoubleDescriptive.sumOfPowerDeviations(doubleArrayList, i, 0.0, n, n2);
            }
            return;
        }
        double[] dArray5 = doubleArrayList.elements();
        int n11 = n - 1;
        while (++n11 <= n2) {
            double d = dArray5[n11];
            double d11 = Math.pow(d, n3);
            int n12 = 0;
            int n13 = n6;
            while (--n13 >= 0) {
                int n14 = n12++;
                dArray[n14] = dArray[n14] + d11;
                d11 *= d;
            }
            int n15 = n12;
            dArray[n15] = dArray[n15] + d11;
        }
    }

    public static void incrementalWeightedUpdate(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, int n, int n2, double[] dArray) {
        int n3 = doubleArrayList.size();
        DoubleDescriptive.checkRangeFromTo(n, n2, n3);
        if (n3 != doubleArrayList2.size()) {
            throw new IllegalArgumentException("from=" + n + ", to=" + n2 + ", data.size()=" + n3 + ", weights.size()=" + doubleArrayList2.size());
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double[] dArray2 = doubleArrayList.elements();
        double[] dArray3 = doubleArrayList2.elements();
        int n4 = n - 1;
        while (++n4 <= n2) {
            double d3 = dArray2[n4];
            double d4 = dArray3[n4];
            double d5 = d3 * d4;
            d += d5;
            d2 += d3 * d5;
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    public static double kurtosis(double d, double d2) {
        return -3.0 + d / (d2 * d2 * d2 * d2);
    }

    public static double kurtosis(DoubleArrayList doubleArrayList, double d, double d2) {
        return DoubleDescriptive.kurtosis(DoubleDescriptive.moment(doubleArrayList, 4, d), d2);
    }

    public static double lag1(DoubleArrayList doubleArrayList, double d) {
        int n = doubleArrayList.size();
        double[] dArray = doubleArrayList.elements();
        double d2 = 0.0;
        double d3 = (dArray[0] - d) * (dArray[0] - d);
        for (int i = 1; i < n; ++i) {
            double d4 = dArray[i - 1] - d;
            double d5 = dArray[i] - d;
            d2 += (d4 * d5 - d2) / (double)(i + 1);
            d3 += (d5 * d5 - d3) / (double)(i + 1);
        }
        double d6 = d2 / d3;
        return d6;
    }

    public static double max(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double d = dArray[n - 1];
        int n2 = n - 1;
        while (--n2 >= 0) {
            if (!(dArray[n2] > d)) continue;
            d = dArray[n2];
        }
        return d;
    }

    public static double mean(DoubleArrayList doubleArrayList) {
        return DoubleDescriptive.sum(doubleArrayList) / (double)doubleArrayList.size();
    }

    public static double meanDeviation(DoubleArrayList doubleArrayList, double d) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d2 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            d2 += Math.abs(dArray[n2] - d);
        }
        return d2 / (double)n;
    }

    public static double median(DoubleArrayList doubleArrayList) {
        return DoubleDescriptive.quantile(doubleArrayList, 0.5);
    }

    public static double min(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double d = dArray[n - 1];
        int n2 = n - 1;
        while (--n2 >= 0) {
            if (!(dArray[n2] < d)) continue;
            d = dArray[n2];
        }
        return d;
    }

    public static double moment(int n, double d, int n2, double[] dArray) {
        double d2 = 0.0;
        int n3 = 1;
        for (int i = 0; i <= n; ++i) {
            double d3 = i == 0 ? 1.0 : (i == 1 ? d : (i == 2 ? d * d : (i == 3 ? d * d * d : Math.pow(d, i))));
            d2 += (double)n3 * DoubleArithmetic.binomial(n, (long)i) * d3 * dArray[n - i];
            n3 = -n3;
        }
        return d2 / (double)n2;
    }

    public static double moment(DoubleArrayList doubleArrayList, int n, double d) {
        return DoubleDescriptive.sumOfPowerDeviations(doubleArrayList, n, d) / (double)doubleArrayList.size();
    }

    public static double pooledMean(int n, double d, int n2, double d2) {
        return ((double)n * d + (double)n2 * d2) / (double)(n + n2);
    }

    public static double pooledVariance(int n, double d, int n2, double d2) {
        return ((double)n * d + (double)n2 * d2) / (double)(n + n2);
    }

    public static double product(int n, double d) {
        return Math.pow(Math.exp(d / (double)n), n);
    }

    public static double product(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        double[] dArray = doubleArrayList.elements();
        double d = 1.0;
        int n2 = n;
        while (--n2 >= 0) {
            d *= dArray[n2];
        }
        return d;
    }

    public static double quantile(DoubleArrayList doubleArrayList, double d) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d2 = d * (double)(n - 1);
        int n2 = (int)d2;
        double d3 = d2 - (double)n2;
        if (n == 0) {
            return 0.0;
        }
        double d4 = n2 == n - 1 ? dArray[n2] : (1.0 - d3) * dArray[n2] + d3 * dArray[n2 + 1];
        return d4;
    }

    public static double quantileInverse(DoubleArrayList doubleArrayList, double d) {
        return DoubleDescriptive.rankInterpolated(doubleArrayList, d) / (double)doubleArrayList.size();
    }

    public static DoubleArrayList quantiles(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList2.size();
        DoubleArrayList doubleArrayList3 = new DoubleArrayList(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayList3.add(DoubleDescriptive.quantile(doubleArrayList, doubleArrayList2.get(i)));
        }
        return doubleArrayList3;
    }

    public static double rankInterpolated(DoubleArrayList doubleArrayList, double d) {
        int n = doubleArrayList.binarySearch(d);
        if (n >= 0) {
            int n2;
            int n3 = doubleArrayList.size();
            for (n2 = n + 1; n2 < n3 && doubleArrayList.get(n2) == d; ++n2) {
            }
            return n2;
        }
        int n4 = -n - 1;
        if (n4 == 0 || n4 == doubleArrayList.size()) {
            return n4;
        }
        double d2 = doubleArrayList.get(n4 - 1);
        double d3 = doubleArrayList.get(n4);
        double d4 = (d - d2) / (d3 - d2);
        return (double)n4 + d4;
    }

    public static double rms(int n, double d) {
        return Math.sqrt(d / (double)n);
    }

    public static double sampleKurtosis(int n, double d, double d2) {
        int n2 = n;
        double d3 = d2;
        double d4 = d * (double)n2;
        return d4 * (double)n2 * (double)(n2 + 1) / ((double)((n2 - 1) * (n2 - 2) * (n2 - 3)) * d3 * d3) - 3.0 * (double)(n2 - 1) * (double)(n2 - 1) / (double)((n2 - 2) * (n2 - 3));
    }

    public static double sampleKurtosis(DoubleArrayList doubleArrayList, double d, double d2) {
        return DoubleDescriptive.sampleKurtosis(doubleArrayList.size(), DoubleDescriptive.moment(doubleArrayList, 4, d), d2);
    }

    public static double sampleKurtosisStandardError(int n) {
        int n2 = n;
        return Math.sqrt(24.0 * (double)n2 * (double)(n2 - 1) * (double)(n2 - 1) / (double)((n2 - 3) * (n2 - 2) * (n2 + 3) * (n2 + 5)));
    }

    public static double sampleSkew(int n, double d, double d2) {
        int n2 = n;
        double d3 = Math.sqrt(d2);
        double d4 = d * (double)n2;
        return (double)n2 * d4 / ((double)((n2 - 1) * (n2 - 2)) * d3 * d3 * d3);
    }

    public static double sampleSkew(DoubleArrayList doubleArrayList, double d, double d2) {
        return DoubleDescriptive.sampleSkew(doubleArrayList.size(), DoubleDescriptive.moment(doubleArrayList, 3, d), d2);
    }

    public static double sampleSkewStandardError(int n) {
        int n2 = n;
        return Math.sqrt(6.0 * (double)n2 * (double)(n2 - 1) / (double)((n2 - 2) * (n2 + 1) * (n2 + 3)));
    }

    public static double sampleStandardDeviation(int n, double d) {
        int n2 = n;
        double d2 = Math.sqrt(d);
        double d3 = n2 > 30 ? 1.0 + 1.0 / (double)(4 * (n2 - 1)) : Math.sqrt((double)(n2 - 1) * 0.5) * Gamma.gamma((double)(n2 - 1) * 0.5) / Gamma.gamma((double)n2 * 0.5);
        return d3 * d2;
    }

    public static double sampleVariance(int n, double d, double d2) {
        double d3 = d / (double)n;
        return (d2 - d3 * d) / (double)(n - 1);
    }

    public static double sampleVariance(DoubleArrayList doubleArrayList, double d) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d2 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            double d3 = dArray[n2] - d;
            d2 += d3 * d3;
        }
        return d2 / (double)(n - 1);
    }

    public static double sampleWeightedVariance(double d, double d2, double d3) {
        return (d3 - d2 * d2 / d) / (d - 1.0);
    }

    public static double skew(double d, double d2) {
        return d / (d2 * d2 * d2);
    }

    public static double skew(DoubleArrayList doubleArrayList, double d, double d2) {
        return DoubleDescriptive.skew(DoubleDescriptive.moment(doubleArrayList, 3, d), d2);
    }

    public static DoubleArrayList[] split(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList2.size() + 1;
        DoubleArrayList[] doubleArrayListArray = new DoubleArrayList[n];
        int n2 = n;
        while (--n2 >= 0) {
            doubleArrayListArray[n2] = new DoubleArrayList();
        }
        n2 = doubleArrayList.size();
        int n3 = 0;
        for (int i = 0; n3 < n2 && i < n - 1; ++i) {
            double d = doubleArrayList2.get(i);
            int n4 = doubleArrayList.binarySearch(d);
            if (n4 < 0) {
                int n5 = -n4 - 1;
                doubleArrayListArray[i].addAllOfFromTo(doubleArrayList, n3, n5 - 1);
                n3 = n5;
                continue;
            }
            while (--n4 >= 0 && doubleArrayList.get(n4) == d) {
            }
            doubleArrayListArray[i].addAllOfFromTo(doubleArrayList, n3, n4);
            n3 = n4 + 1;
        }
        doubleArrayListArray[n - 1].addAllOfFromTo(doubleArrayList, n3, doubleArrayList.size() - 1);
        return doubleArrayListArray;
    }

    public static double standardDeviation(double d) {
        return Math.sqrt(d);
    }

    public static double standardError(int n, double d) {
        return Math.sqrt(d / (double)n);
    }

    public static void standardize(DoubleArrayList doubleArrayList, double d, double d2) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        while (--n >= 0) {
            dArray[n] = (dArray[n] - d) / d2;
        }
    }

    public static double sum(DoubleArrayList doubleArrayList) {
        return DoubleDescriptive.sumOfPowerDeviations(doubleArrayList, 1, 0.0);
    }

    public static double sumOfInversions(DoubleArrayList doubleArrayList, int n, int n2) {
        return DoubleDescriptive.sumOfPowerDeviations(doubleArrayList, -1, 0.0, n, n2);
    }

    public static double sumOfLogarithms(DoubleArrayList doubleArrayList, int n, int n2) {
        double[] dArray = doubleArrayList.elements();
        double d = 0.0;
        int n3 = n - 1;
        while (++n3 <= n2) {
            d += Math.log(dArray[n3]);
        }
        return d;
    }

    public static double sumOfPowerDeviations(DoubleArrayList doubleArrayList, int n, double d) {
        return DoubleDescriptive.sumOfPowerDeviations(doubleArrayList, n, d, 0, doubleArrayList.size() - 1);
    }

    public static double sumOfPowerDeviations(DoubleArrayList doubleArrayList, int n, double d, int n2, int n3) {
        double[] dArray = doubleArrayList.elements();
        double d2 = 0.0;
        switch (n) {
            case -2: {
                if (d == 0.0) {
                    int n4 = n2 - 1;
                    while (++n4 <= n3) {
                        double d3 = dArray[n4];
                        d2 += 1.0 / (d3 * d3);
                    }
                } else {
                    int n5 = n2 - 1;
                    while (++n5 <= n3) {
                        double d4 = dArray[n5] - d;
                        d2 += 1.0 / (d4 * d4);
                    }
                }
                break;
            }
            case -1: {
                if (d == 0.0) {
                    int n6 = n2 - 1;
                    while (++n6 <= n3) {
                        d2 += 1.0 / dArray[n6];
                    }
                } else {
                    int n7 = n2 - 1;
                    while (++n7 <= n3) {
                        d2 += 1.0 / (dArray[n7] - d);
                    }
                }
                break;
            }
            case 0: {
                d2 += (double)(n3 - n2 + 1);
                break;
            }
            case 1: {
                if (d == 0.0) {
                    int n8 = n2 - 1;
                    while (++n8 <= n3) {
                        d2 += dArray[n8];
                    }
                } else {
                    int n9 = n2 - 1;
                    while (++n9 <= n3) {
                        d2 += dArray[n9] - d;
                    }
                }
                break;
            }
            case 2: {
                if (d == 0.0) {
                    int n10 = n2 - 1;
                    while (++n10 <= n3) {
                        double d5 = dArray[n10];
                        d2 += d5 * d5;
                    }
                } else {
                    int n11 = n2 - 1;
                    while (++n11 <= n3) {
                        double d6 = dArray[n11] - d;
                        d2 += d6 * d6;
                    }
                }
                break;
            }
            case 3: {
                if (d == 0.0) {
                    int n12 = n2 - 1;
                    while (++n12 <= n3) {
                        double d7 = dArray[n12];
                        d2 += d7 * d7 * d7;
                    }
                } else {
                    int n13 = n2 - 1;
                    while (++n13 <= n3) {
                        double d8 = dArray[n13] - d;
                        d2 += d8 * d8 * d8;
                    }
                }
                break;
            }
            case 4: {
                if (d == 0.0) {
                    int n14 = n2 - 1;
                    while (++n14 <= n3) {
                        double d9 = dArray[n14];
                        d2 += d9 * d9 * d9 * d9;
                    }
                } else {
                    int n15 = n2 - 1;
                    while (++n15 <= n3) {
                        double d10 = dArray[n15] - d;
                        d2 += d10 * d10 * d10 * d10;
                    }
                }
                break;
            }
            case 5: {
                if (d == 0.0) {
                    int n16 = n2 - 1;
                    while (++n16 <= n3) {
                        double d11 = dArray[n16];
                        d2 += d11 * d11 * d11 * d11 * d11;
                    }
                } else {
                    int n17 = n2 - 1;
                    while (++n17 <= n3) {
                        double d12 = dArray[n17] - d;
                        d2 += d12 * d12 * d12 * d12 * d12;
                    }
                }
                break;
            }
            default: {
                int n18 = n2 - 1;
                while (++n18 <= n3) {
                    d2 += Math.pow(dArray[n18] - d, n);
                }
                break block0;
            }
        }
        return d2;
    }

    public static double sumOfPowers(DoubleArrayList doubleArrayList, int n) {
        return DoubleDescriptive.sumOfPowerDeviations(doubleArrayList, n, 0.0);
    }

    public static double sumOfSquaredDeviations(int n, double d) {
        return d * (double)(n - 1);
    }

    public static double sumOfSquares(DoubleArrayList doubleArrayList) {
        return DoubleDescriptive.sumOfPowerDeviations(doubleArrayList, 2, 0.0);
    }

    public static double trimmedMean(DoubleArrayList doubleArrayList, double d, int n, int n2) {
        int n3;
        int n4 = doubleArrayList.size();
        if (n4 == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (n + n2 >= n4) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double[] dArray = doubleArrayList.elements();
        int n5 = n4;
        for (n3 = 0; n3 < n; ++n3) {
            d += (d - dArray[n3]) / (double)(--n4);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            d += (d - dArray[n5 - 1 - n3]) / (double)(--n4);
        }
        return d;
    }

    public static double variance(double d) {
        return d * d;
    }

    public static double variance(int n, double d, double d2) {
        double d3 = d / (double)n;
        return (d2 - d3 * d) / (double)n;
    }

    public static double weightedMean(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList.size();
        if (n != doubleArrayList2.size() || n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double[] dArray2 = doubleArrayList2.elements();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            double d3 = dArray2[n2];
            d += dArray[n2] * d3;
            d2 += d3;
        }
        return d / d2;
    }

    public static double weightedRMS(double d, double d2) {
        return d / d2;
    }

    public static double winsorizedMean(DoubleArrayList doubleArrayList, double d, int n, int n2) {
        int n3 = doubleArrayList.size();
        if (n3 == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (n + n2 >= n3) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double[] dArray = doubleArrayList.elements();
        double d2 = dArray[n];
        for (int i = 0; i < n; ++i) {
            d += (d2 - dArray[i]) / (double)n3;
        }
        double d3 = dArray[n3 - 1 - n2];
        for (int i = 0; i < n2; ++i) {
            d += (d3 - dArray[n3 - 1 - i]) / (double)n3;
        }
        return d;
    }
}

