/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat.sampling;

import cern.colt.PersistentObject;
import cern.colt.list.tboolean.BooleanArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.random.tfloat.AbstractFloatDistribution;
import cern.jet.random.tfloat.FloatUniform;
import cern.jet.random.tfloat.engine.FloatRandomEngine;

public class WeightedFloatRandomSampler
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected int skip;
    protected int nextTriggerPos;
    protected int nextSkip;
    protected int weight;
    protected FloatUniform generator;
    static final int UNDEFINED = -1;

    public WeightedFloatRandomSampler() {
        this(1, null);
    }

    public WeightedFloatRandomSampler(int n, FloatRandomEngine floatRandomEngine) {
        if (floatRandomEngine == null) {
            floatRandomEngine = AbstractFloatDistribution.makeDefaultGenerator();
        }
        this.generator = new FloatUniform(floatRandomEngine);
        this.setWeight(n);
    }

    public Object clone() {
        WeightedFloatRandomSampler weightedFloatRandomSampler = (WeightedFloatRandomSampler)super.clone();
        weightedFloatRandomSampler.generator = (FloatUniform)this.generator.clone();
        return weightedFloatRandomSampler;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean sampleNextElement() {
        if (this.skip > 0) {
            --this.skip;
            return false;
        }
        if (this.nextTriggerPos == -1) {
            this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
            this.nextSkip = this.weight - 1 - this.nextTriggerPos;
        }
        if (this.nextTriggerPos > 0) {
            --this.nextTriggerPos;
            return false;
        }
        this.nextTriggerPos = -1;
        this.skip = this.nextSkip;
        return true;
    }

    public void setWeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("bad weight");
        }
        this.weight = n;
        this.skip = 0;
        this.nextTriggerPos = -1;
        this.nextSkip = 0;
    }

    public static void test(int n, int n2) {
        WeightedFloatRandomSampler weightedFloatRandomSampler = new WeightedFloatRandomSampler();
        weightedFloatRandomSampler.setWeight(n);
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < n2; ++i) {
            if (!weightedFloatRandomSampler.sampleNextElement()) continue;
            intArrayList.add(i);
        }
        System.out.println("Sample = " + intArrayList);
    }

    private void xsampleNextElements(BooleanArrayList booleanArrayList) {
        int n = booleanArrayList.size();
        boolean[] blArray = booleanArrayList.elements();
        for (int i = 0; i < n; ++i) {
            if (this.skip > 0) {
                --this.skip;
                blArray[i] = false;
                continue;
            }
            if (this.nextTriggerPos == -1) {
                this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
                this.nextSkip = this.weight - 1 - this.nextTriggerPos;
            }
            if (this.nextTriggerPos > 0) {
                --this.nextTriggerPos;
                blArray[i] = false;
                continue;
            }
            this.nextTriggerPos = -1;
            this.skip = this.nextSkip;
            blArray[i] = true;
        }
    }
}

