/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.ref.DoubleAbstractHistogram1D;
import hep.aida.tdouble.ref.DoubleFixedAxis;
import hep.aida.tdouble.ref.DoubleHistogram1DContents;
import hep.aida.tdouble.ref.DoubleVariableAxis;
import java.util.concurrent.Future;

public class DoubleHistogram1D
extends DoubleAbstractHistogram1D
implements DoubleIHistogram1D {
    private static final long serialVersionUID = 1L;
    private double[] errors;
    private double[] heights;
    private int[] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double mean;
    private double rms;

    public DoubleHistogram1D(String string, double[] dArray) {
        this(string, new DoubleVariableAxis(dArray));
    }

    public DoubleHistogram1D(String string, DoubleIAxis doubleIAxis) {
        super(string);
        this.xAxis = doubleIAxis;
        int n = doubleIAxis.bins();
        this.entries = new int[n + 2];
        this.heights = new double[n + 2];
        this.errors = new double[n + 2];
    }

    public DoubleHistogram1D(String string, int n, double d, double d2) {
        this(string, new DoubleFixedAxis(n, d, d2));
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int n) {
        return this.entries[this.map(n)];
    }

    public double binError(int n) {
        return Math.sqrt(this.errors[this.map(n)]);
    }

    public double binHeight(int n) {
        return this.heights[this.map(n)];
    }

    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(double d) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(d));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + 1.0;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.mean += d;
        this.rms += d * d;
    }

    public void fill(double d, double d2) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(d));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + d2;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + d2 * d2;
        ++this.nEntry;
        this.sumWeight += d2;
        this.sumWeightSquared += d2 * d2;
        this.mean += d * d2;
        this.rms += d * d2 * d2;
    }

    public void fill_2D(final double[] dArray, int n, final int n2, final int n3, final int n4, final int n5) {
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n * n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n6 = Math.min(n6, n);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int n;
                        double[] dArray5 = new double[DoubleHistogram1D.this.errors.length];
                        double[] dArray2 = new double[DoubleHistogram1D.this.heights.length];
                        int[] nArray = new int[DoubleHistogram1D.this.entries.length];
                        int n22 = 0;
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        int n32 = n3 + n8 * n4;
                        for (int i = n8; i < n9; ++i) {
                            n = n32;
                            for (int j = 0; j < n2; ++j) {
                                int n42;
                                int n52 = n42 = DoubleHistogram1D.this.map(DoubleHistogram1D.this.xAxis.coordToIndex(dArray[n]));
                                nArray[n52] = nArray[n52] + 1;
                                int n6 = n42;
                                dArray2[n6] = dArray2[n6] + 1.0;
                                int n7 = n42;
                                dArray5[n7] = dArray5[n7] + 1.0;
                                ++n22;
                                d += 1.0;
                                d2 += 1.0;
                                d3 += dArray[n];
                                d4 += dArray[n] * dArray[n];
                                n += n5;
                            }
                            n32 += n4;
                        }
                        1 var14_11 = this;
                        synchronized (var14_11) {
                            for (n = 0; n < DoubleHistogram1D.this.entries.length; ++n) {
                                double[] dArray3 = DoubleHistogram1D.this.errors;
                                int n82 = n;
                                dArray3[n82] = dArray3[n82] + dArray5[n];
                                double[] dArray4 = DoubleHistogram1D.this.heights;
                                int n92 = n;
                                dArray4[n92] = dArray4[n92] + dArray2[n];
                                int[] nArray2 = DoubleHistogram1D.this.entries;
                                int n10 = n;
                                nArray2[n10] = nArray2[n10] + nArray[n];
                            }
                            DoubleHistogram1D.this.nEntry += n22;
                            DoubleHistogram1D.this.sumWeight += d;
                            DoubleHistogram1D.this.sumWeightSquared += d2;
                            DoubleHistogram1D.this.mean += d3;
                            DoubleHistogram1D.this.rms += d4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            for (int i = 0; i < n; ++i) {
                int n11 = n10;
                for (int j = 0; j < n2; ++j) {
                    int n12;
                    int n13 = n12 = this.map(this.xAxis.coordToIndex(dArray[n11]));
                    this.entries[n13] = this.entries[n13] + 1;
                    int n14 = n12;
                    this.heights[n14] = this.heights[n14] + 1.0;
                    int n15 = n12;
                    this.errors[n15] = this.errors[n15] + 1.0;
                    ++this.nEntry;
                    this.sumWeight += 1.0;
                    this.sumWeightSquared += 1.0;
                    this.mean += dArray[n11];
                    this.rms += dArray[n11] * dArray[n11];
                    n11 += n5;
                }
                n10 += n4;
            }
        }
    }

    public void fill_2D(final double[] dArray, final double[] dArray2, int n, final int n2, final int n3, final int n4, final int n5) {
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n * n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n6 = Math.min(n6, n);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int n;
                        int n22 = n3 + n8 * n4;
                        double[] dArray5 = new double[DoubleHistogram1D.this.errors.length];
                        double[] dArray22 = new double[DoubleHistogram1D.this.heights.length];
                        int[] nArray = new int[DoubleHistogram1D.this.entries.length];
                        int n32 = 0;
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        for (int i = n8; i < n9; ++i) {
                            n = n22;
                            for (int j = 0; j < n2; ++j) {
                                int n42 = DoubleHistogram1D.this.map(DoubleHistogram1D.this.xAxis.coordToIndex(dArray[n]));
                                int n52 = i * n2 + j;
                                double d5 = dArray2[n52] * dArray2[n52];
                                int n6 = n42;
                                nArray[n6] = nArray[n6] + 1;
                                int n7 = n42;
                                dArray22[n7] = dArray22[n7] + dArray2[n52];
                                int n82 = n42;
                                dArray5[n82] = dArray5[n82] + d5;
                                ++n32;
                                d += dArray2[n52];
                                d2 += d5;
                                d3 += dArray[n] * dArray2[n52];
                                d4 += dArray[n] * d5;
                                n += n5;
                            }
                            n22 += n4;
                        }
                        2 var14_11 = this;
                        synchronized (var14_11) {
                            for (n = 0; n < DoubleHistogram1D.this.entries.length; ++n) {
                                double[] dArray3 = DoubleHistogram1D.this.errors;
                                int n92 = n;
                                dArray3[n92] = dArray3[n92] + dArray5[n];
                                double[] dArray4 = DoubleHistogram1D.this.heights;
                                int n10 = n;
                                dArray4[n10] = dArray4[n10] + dArray22[n];
                                int[] nArray2 = DoubleHistogram1D.this.entries;
                                int n11 = n;
                                nArray2[n11] = nArray2[n11] + nArray[n];
                            }
                            DoubleHistogram1D.this.nEntry += n32;
                            DoubleHistogram1D.this.sumWeight += d;
                            DoubleHistogram1D.this.sumWeightSquared += d2;
                            DoubleHistogram1D.this.mean += d3;
                            DoubleHistogram1D.this.rms += d4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            for (int i = 0; i < n; ++i) {
                int n11 = n10;
                for (int j = 0; j < n2; ++j) {
                    int n12 = this.map(this.xAxis.coordToIndex(dArray[n11]));
                    int n13 = i * n2 + j;
                    double d = dArray2[n13] * dArray2[n13];
                    int n14 = n12;
                    this.entries[n14] = this.entries[n14] + 1;
                    int n15 = n12;
                    this.heights[n15] = this.heights[n15] + dArray2[n13];
                    int n16 = n12;
                    this.errors[n16] = this.errors[n16] + d;
                    ++this.nEntry;
                    this.sumWeight += dArray2[n13];
                    this.sumWeightSquared += d;
                    this.mean += dArray[n11] * dArray2[n13];
                    this.rms += dArray[n11] * d;
                    n11 += n5;
                }
                n10 += n4;
            }
        }
    }

    public DoubleHistogram1DContents getContents() {
        return new DoubleHistogram1DContents(this.entries, this.heights, this.errors, this.nEntry, this.sumWeight, this.sumWeightSquared, this.mean, this.rms);
    }

    public double mean() {
        return this.mean / this.sumWeight;
    }

    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = 0;
            this.heights[i] = 0.0;
            this.errors[i] = 0.0;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.mean = 0.0;
        this.rms = 0.0;
    }

    public double rms() {
        return Math.sqrt(this.rms / this.sumWeight - this.mean * this.mean / this.sumWeight / this.sumWeight);
    }

    public void setContents(DoubleHistogram1DContents doubleHistogram1DContents) {
        this.entries = doubleHistogram1DContents.getEntries();
        this.heights = doubleHistogram1DContents.getHeights();
        this.errors = doubleHistogram1DContents.getErrors();
        this.nEntry = doubleHistogram1DContents.getNentry();
        this.sumWeight = doubleHistogram1DContents.getSumWeight();
        this.sumWeightSquared = doubleHistogram1DContents.getSumWeightSquared();
        this.mean = doubleHistogram1DContents.getMean();
        this.rms = doubleHistogram1DContents.getRms();
    }

    void setContents(int[] nArray, double[] dArray, double[] dArray2) {
        this.entries = nArray;
        this.heights = dArray;
        this.errors = dArray2;
        for (int i = 0; i < nArray.length; ++i) {
            this.nEntry += nArray[i];
            this.sumWeight += dArray[i];
        }
        this.sumWeightSquared = Double.NaN;
        this.mean = Double.NaN;
        this.rms = Double.NaN;
    }
}

