/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.function.tdouble.LongDoubleProcedure;
import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.map.tdouble.OpenLongDoubleHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedSparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import java.io.IOException;

public class SparseDoubleMatrix2D
extends DoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongDoubleMap elements;

    public SparseDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public SparseDoubleMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2, 0.5);
    }

    public SparseDoubleMatrix2D(int n, int n2, int n3, double d, double d2) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongDoubleHashMap(n3, d, d2);
    }

    public SparseDoubleMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double d) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongDoubleHashMap(nArray.length);
        this.insert(nArray, nArray2, d);
    }

    public SparseDoubleMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongDoubleHashMap(nArray.length);
        this.insert(nArray, nArray2, dArray);
    }

    public SparseDoubleMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block9: {
            double[] dArray;
            int[] nArray;
            int[] nArray2;
            int n;
            MatrixInfo matrixInfo;
            block8: {
                MatrixSize matrixSize;
                block7: {
                    matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (matrixInfo.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (matrixInfo.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (matrixInfo.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                    try {
                        this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                        throw illegalArgumentException;
                    }
                }
                n = matrixSize.numEntries();
                nArray2 = new int[n];
                nArray = new int[n];
                dArray = new double[n];
                matrixVectorReader.readCoordinate(nArray, nArray2, dArray);
                this.elements = matrixInfo.isSymmetric() || matrixInfo.isSkewSymmetric() ? new OpenLongDoubleHashMap(2 * nArray.length) : new OpenLongDoubleHashMap(nArray.length);
                this.insert(nArray, nArray2, dArray);
                if (!matrixInfo.isSymmetric()) break block8;
                for (int i = 0; i < n; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    this.set(nArray2[i], nArray[i], dArray[i]);
                }
                break block9;
            }
            if (!matrixInfo.isSkewSymmetric()) break block9;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                this.set(nArray2[i], nArray[i], -dArray[i]);
            }
        }
    }

    protected SparseDoubleMatrix2D(int n, int n2, AbstractLongDoubleMap abstractLongDoubleMap, int n3, int n4, int n5, int n6) {
        block2: {
            try {
                this.setUp(n, n2, n3, n4, n5, n6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = abstractLongDoubleMap;
        this.isNoView = false;
    }

    public DoubleMatrix2D assign(DoubleFunction doubleFunction) {
        if (this.isNoView && doubleFunction instanceof DoubleMult) {
            this.elements.assign(doubleFunction);
        } else {
            super.assign(doubleFunction);
        }
        return this;
    }

    public DoubleMatrix2D assign(double d) {
        if (this.isNoView && d == 0.0) {
            this.elements.clear();
        } else {
            super.assign(d);
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (!(doubleMatrix2D instanceof SparseDoubleMatrix2D)) {
            return super.assign(doubleMatrix2D);
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = (SparseDoubleMatrix2D)doubleMatrix2D;
        if (sparseDoubleMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseDoubleMatrix2D);
        if (this.isNoView && sparseDoubleMatrix2D.isNoView) {
            this.elements.assign(sparseDoubleMatrix2D.elements);
            return this;
        }
        return super.assign(doubleMatrix2D);
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        if (!this.isNoView) {
            return super.assign(doubleMatrix2D, doubleDoubleFunction);
        }
        this.checkShape(doubleMatrix2D);
        if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            final double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    SparseDoubleMatrix2D.this.setQuick(n, n2, SparseDoubleMatrix2D.this.getQuick(n, n2) + d * d2);
                    return d2;
                }
            });
        } else if (doubleDoubleFunction == DoubleFunctions.mult) {
            this.elements.forEachPair(new LongDoubleProcedure(){

                public boolean apply(long l, double d) {
                    int n;
                    int n2 = (int)(l / (long)SparseDoubleMatrix2D.this.columns);
                    double d2 = d * doubleMatrix2D.getQuick(n2, n = (int)(l % (long)SparseDoubleMatrix2D.this.columns));
                    if (d2 != d) {
                        SparseDoubleMatrix2D.this.elements.put(l, d2);
                    }
                    return true;
                }
            });
        } else if (doubleDoubleFunction == DoubleFunctions.div) {
            this.elements.forEachPair(new LongDoubleProcedure(){

                public boolean apply(long l, double d) {
                    int n;
                    int n2 = (int)(l / (long)SparseDoubleMatrix2D.this.columns);
                    double d2 = d / doubleMatrix2D.getQuick(n2, n = (int)(l % (long)SparseDoubleMatrix2D.this.columns));
                    if (d2 != d) {
                        SparseDoubleMatrix2D.this.elements.put(l, d2);
                    }
                    return true;
                }
            });
        } else {
            super.assign(doubleMatrix2D, doubleDoubleFunction);
        }
        return this;
    }

    public SparseDoubleMatrix2D assign(int[] nArray, int[] nArray2, double d, DoubleDoubleFunction doubleDoubleFunction) {
        int n = nArray.length;
        if (doubleDoubleFunction == DoubleFunctions.plus) {
            for (int i = 0; i < n; ++i) {
                long l = nArray[i];
                long l2 = nArray2[i];
                if (l >= (long)this.rows || l2 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
                }
                long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
                double d2 = this.elements.get(l3);
                double d3 = d2 + d;
                if (d3 != 0.0) {
                    this.elements.put(l3, d3);
                    continue;
                }
                this.elements.removeKey(l3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                long l = nArray[i];
                long l4 = nArray2[i];
                if (l >= (long)this.rows || l4 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l4);
                }
                long l5 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l4 * (long)this.columnStride;
                double d4 = this.elements.get(l5);
                double d5 = doubleDoubleFunction.apply(d4, d);
                if (d5 != 0.0) {
                    this.elements.put(l5, d5);
                    continue;
                }
                this.elements.removeKey(l5);
            }
        }
        return this;
    }

    public SparseDoubleMatrix2D assign(int[] nArray, int[] nArray2, double[] dArray, DoubleDoubleFunction doubleDoubleFunction) {
        int n = nArray.length;
        if (doubleDoubleFunction == DoubleFunctions.plus) {
            for (int i = 0; i < n; ++i) {
                double d = dArray[i];
                long l = nArray[i];
                long l2 = nArray2[i];
                if (l >= (long)this.rows || l2 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
                }
                long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
                double d2 = this.elements.get(l3);
                if ((d += d2) != 0.0) {
                    this.elements.put(l3, d);
                    continue;
                }
                this.elements.removeKey(l3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double d = dArray[i];
                long l = nArray[i];
                long l4 = nArray2[i];
                if (l >= (long)this.rows || l4 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l4);
                }
                long l5 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l4 * (long)this.columnStride;
                double d3 = this.elements.get(l5);
                d = doubleDoubleFunction.apply(d3, d);
                if (d != 0.0) {
                    this.elements.put(l5, d);
                    continue;
                }
                this.elements.removeKey(l5);
            }
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCDoubleMatrix2D getColumnCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        double[] dArray = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseCCDoubleMatrix2D(this.rows, this.columns, nArray, nArray2, dArray, false, false, bl);
    }

    public SparseCCMDoubleMatrix2D getColumnCompressedModified() {
        SparseCCMDoubleMatrix2D sparseCCMDoubleMatrix2D = new SparseCCMDoubleMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        double[] dArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseCCMDoubleMatrix2D.setQuick(n2, n3, dArray[i]);
        }
        return sparseCCMDoubleMatrix2D;
    }

    public SparseRCDoubleMatrix2D getRowCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        double[] dArray = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseRCDoubleMatrix2D(this.rows, this.columns, nArray, nArray2, dArray, false, false, bl);
    }

    public SparseRCMDoubleMatrix2D getRowCompressedModified() {
        SparseRCMDoubleMatrix2D sparseRCMDoubleMatrix2D = new SparseRCMDoubleMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        double[] dArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseRCMDoubleMatrix2D.setQuick(n2, n3, dArray[i]);
        }
        return sparseRCMDoubleMatrix2D;
    }

    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction intIntDoubleFunction) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongDoubleProcedure(){

                public boolean apply(long l, double d) {
                    int n;
                    int n2 = (int)(l / (long)SparseDoubleMatrix2D.this.columns);
                    double d2 = intIntDoubleFunction.apply(n2, n = (int)(l % (long)SparseDoubleMatrix2D.this.columns), d);
                    if (d2 != d) {
                        SparseDoubleMatrix2D.this.elements.put(l, d2);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(intIntDoubleFunction);
        }
        return this;
    }

    public synchronized double getQuick(int n, int n2) {
        return this.elements.get((long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride);
    }

    public long index(int n, int n2) {
        return (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, double d) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (d == 0.0) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, d);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double d = this.getQuick(i, j);
                if (d == 0.0) continue;
                stringBuilder.append('(').append(i).append(',').append(j).append(')').append('\t').append(d).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public DoubleMatrix1D vectorize() {
        SparseDoubleMatrix1D sparseDoubleMatrix1D = new SparseDoubleMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                double d = this.getQuick(j, i);
                sparseDoubleMatrix1D.setQuick(n++, d);
            }
        }
        return sparseDoubleMatrix1D;
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, final double d, double d2, final boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = doubleMatrix1D2 == null;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(this.isNoView && doubleMatrix1D instanceof DenseDoubleMatrix1D && doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if ((long)n2 != doubleMatrix1D.size() || (long)n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        if (!bl2) {
            doubleMatrix1D2.assign(DoubleFunctions.mult(d2));
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        final double[] dArray = denseDoubleMatrix1D.elements;
        final int n3 = denseDoubleMatrix1D.stride();
        final int n4 = (int)doubleMatrix1D2.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        final double[] dArray2 = denseDoubleMatrix1D2.elements;
        final int n5 = denseDoubleMatrix1D2.stride();
        final int n6 = (int)doubleMatrix1D.index(0);
        if (dArray2 == null || dArray == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d2) {
                int n = (int)(l / (long)SparseDoubleMatrix2D.this.columns);
                int n2 = (int)(l % (long)SparseDoubleMatrix2D.this.columns);
                if (bl) {
                    int n32 = n;
                    n = n2;
                    n2 = n32;
                }
                int n42 = n4 + n3 * n;
                dArray[n42] = dArray[n42] + d * d2 * dArray2[n6 + n5 * n2];
                return true;
            }
        });
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, final double d, double d2, final boolean bl, boolean bl2) {
        boolean bl3;
        if (!this.isNoView) {
            return super.zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, bl, bl2);
        }
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.columns();
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows() != n || doubleMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            doubleMatrix2D2.assign(DoubleFunctions.mult(d2));
        }
        final DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            doubleMatrix1DArray[n4] = doubleMatrix2D.viewRow(n4);
        }
        final DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            doubleMatrix1DArray2[n5] = doubleMatrix2D2.viewRow(n5);
        }
        final DoublePlusMultSecond doublePlusMultSecond = DoublePlusMultSecond.plusMult(0.0);
        this.elements.forEachPair(new LongDoubleProcedure(){

            public boolean apply(long l, double d2) {
                int n = (int)(l / (long)SparseDoubleMatrix2D.this.columns);
                int n2 = (int)(l % (long)SparseDoubleMatrix2D.this.columns);
                doublePlusMultSecond.multiplicator = d2 * d;
                if (!bl) {
                    doubleMatrix1DArray2[n].assign(doubleMatrix1DArray[n2], doublePlusMultSecond);
                } else {
                    doubleMatrix1DArray2[n2].assign(doubleMatrix1DArray[n], doublePlusMultSecond);
                }
                return true;
            }
        });
        return doubleMatrix2D2;
    }

    private void insert(int[] nArray, int[] nArray2, double d) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            long l2 = nArray2[i];
            if (l >= (long)this.rows || l2 >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
            }
            if (d == 0.0) continue;
            long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
            double d2 = this.elements.get(l3);
            if (d2 == 0.0) {
                this.elements.put(l3, d);
                continue;
            }
            double d3 = d2 + d;
            if (d3 == 0.0) {
                this.elements.removeKey(l3);
                continue;
            }
            this.elements.put(l3, d3);
        }
    }

    private void insert(int[] nArray, int[] nArray2, double[] dArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            long l = nArray[i];
            long l2 = nArray2[i];
            if (l >= (long)this.rows || l2 >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
            }
            if (d == 0.0) continue;
            long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
            double d2 = this.elements.get(l3);
            if (d2 == 0.0) {
                this.elements.put(l3, d);
                continue;
            }
            double d3 = d2 + d;
            if (d3 == 0.0) {
                this.elements.removeKey(l3);
                continue;
            }
            this.elements.put(l3, d3);
        }
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D instanceof SelectedSparseDoubleMatrix2D) {
            SelectedSparseDoubleMatrix2D selectedSparseDoubleMatrix2D = (SelectedSparseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == selectedSparseDoubleMatrix2D.elements;
        }
        if (doubleMatrix2D instanceof SparseDoubleMatrix2D) {
            SparseDoubleMatrix2D sparseDoubleMatrix2D = (SparseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == sparseDoubleMatrix2D.elements;
        }
        return false;
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        return new SparseDoubleMatrix1D(n, this.elements, n2, n3);
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseDoubleMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

