/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tlong;

import cern.colt.list.tlong.AbstractLongList;
import cern.colt.matrix.tbit.BitVector;
import cern.colt.matrix.tbit.QuickBitVector;
import cern.jet.math.tdouble.DoubleArithmetic;

public class MinMaxNumberList
extends AbstractLongList {
    private static final long serialVersionUID = 1L;
    protected long minValue;
    protected int bitsPerElement;
    protected long[] bits;
    protected int capacity;

    public MinMaxNumberList(long l, long l2, int n) {
        this.setUp(l, l2, n);
    }

    public void add(long l) {
        if (this.size == this.capacity) {
            this.ensureCapacity(this.size + 1);
        }
        int n = this.size * this.bitsPerElement;
        QuickBitVector.putLongFromTo((long[])this.bits, (long)(l - this.minValue), (int)n, (int)(n + this.bitsPerElement - 1));
        ++this.size;
    }

    public void addAllOfFromTo(long[] lArray, int n, int n2) {
        int n3 = this.bitsPerElement;
        int n4 = n3 - 1;
        long l = this.minValue;
        long[] lArray2 = this.bits;
        this.ensureCapacity(this.size + n2 - n + 1);
        int n5 = this.size * n3;
        int n6 = n;
        int n7 = n2 - n + 1;
        while (--n7 >= 0) {
            QuickBitVector.putLongFromTo((long[])lArray2, (long)(lArray[n6++] - l), (int)n5, (int)(n5 + n4));
            n5 += n3;
        }
        this.size += n2 - n + 1;
    }

    public int bitsPerElement() {
        return this.bitsPerElement;
    }

    public static int bitsPerElement(long l, long l2) {
        int n = 1L + l2 - l > 0L ? (int)Math.round(Math.ceil(DoubleArithmetic.log(2.0, 1L + l2 - l))) : 64;
        return n;
    }

    public void ensureCapacity(int n) {
        int n2 = this.capacity;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            BitVector bitVector = this.toBitVector();
            bitVector.setSize(n3 * this.bitsPerElement);
            this.bits = bitVector.elements();
            this.capacity = n3;
        }
    }

    public long getQuick(int n) {
        int n2 = n * this.bitsPerElement;
        return this.minValue + QuickBitVector.getLongFromTo((long[])this.bits, (int)n2, (int)(n2 + this.bitsPerElement - 1));
    }

    public void partFromTo(int n, int n2, BitVector bitVector, int n3, long[] lArray, int n4) {
        int n5 = n2 - n + 1;
        if (n < 0 || n > n2 || n2 >= this.size || n3 < 0 || bitVector != null && n3 + n5 > bitVector.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n4 < 0 || n4 + n5 > lArray.length) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.minValue;
        int n6 = this.bitsPerElement;
        long[] lArray2 = this.bits;
        int n7 = n3;
        int n8 = n4;
        int n9 = n * n6;
        int n10 = n;
        while (n10 <= n2) {
            if (bitVector == null || bitVector.get(n7)) {
                lArray[n8] = l + QuickBitVector.getLongFromTo((long[])lArray2, (int)n9, (int)(n9 + n6 - 1));
            }
            ++n10;
            ++n7;
            ++n8;
            n9 += n6;
        }
    }

    public void setQuick(int n, long l) {
        int n2 = n * this.bitsPerElement;
        QuickBitVector.putLongFromTo((long[])this.bits, (long)(l - this.minValue), (int)n2, (int)(n2 + this.bitsPerElement - 1));
    }

    public void setSizeRaw(int n) {
        super.setSizeRaw(n);
    }

    protected void setUp(long l, long l2, int n) {
        this.setUpBitsPerEntry(l, l2);
        this.bits = QuickBitVector.makeBitVector((int)n, (int)this.bitsPerElement);
        this.capacity = n;
        this.size = 0;
    }

    protected void setUpBitsPerEntry(long l, long l2) {
        this.bitsPerElement = MinMaxNumberList.bitsPerElement(l, l2);
        this.minValue = this.bitsPerElement != 64 ? l : 0L;
    }

    public BitVector toBitVector() {
        return new BitVector(this.bits, this.capacity * this.bitsPerElement);
    }

    public void trimToSize() {
        int n = this.capacity;
        if (this.size < n) {
            BitVector bitVector = this.toBitVector();
            bitVector.setSize(this.size);
            this.bits = bitVector.elements();
            this.capacity = this.size;
        }
    }

    @Deprecated
    public long xminimum() {
        return this.minValue;
    }
}

