% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\docType{data}
\name{land}
\alias{land}
\title{Polygon of land}
\format{\code{SpatialPolygons} object}
\usage{
land
}
\description{
Land mask as a single \code{SpatialPolygons} object. The land mask was
obtained from the CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model
produced by the National Oceanic and Atmospheric Administration’s Geophysical
Fluid Dynamics Laboratory converted to a Polar Stereographic grid.  (Vecchi
et al. 2014; Msadek et al. 2014). Weights for converting to a polar
stereograhic grid were obtained from the spherical
coordinate remapping and interpolation package (SCRIP) (Jones 1997).
}
\examples{
data(land)
plot(land)
}
\references{
Vecchi, Gabriel A., et al.
            \href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical cyclone activity."} Journal of Climate
            27.21 (2014): 7994-8016.

            Msadek, R., et al.
            \href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions
            of Arctic sea ice extent."} Geophysical Research Letters
            41.14 (2014): 5208-5215.

            Jones, P.W. "A user’s guide for SCRIP: A spherical coordinate
            remapping and interpolation package." Los Alamos National
            Laboratory, Los Alamos, NM (1997).

            Region Mask: National Snow and Ice Data Center, 2017: Region mask
            for the northern hemisphere.
            \url{http://nsidc.org/data/polar-stereo/tools_masks.html}.
}
\keyword{datasets}
