% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{probability.3pl}
\alias{probability.3pl}
\title{3PL probability function}
\usage{
probability.3pl(z = NULL, a = z$a, b = z$b, c = NULL, d = z$d,
  cp = z$cp, theta)
}
\arguments{
\item{z}{Optional. A list with the parameters a b and c specified by keys.}

\item{a}{The discrimination parameter}

\item{b}{The difficulty parameter. (Optional if d is specified)}

\item{c}{The guessing parameter}

\item{d}{Optional. Overrides the b parameter, it is equal to -a*b. Used in some functions.}

\item{cp}{Optional. Overrides the c parameter, it is logit(c)}

\item{theta}{The subject's latent trait.}
}
\value{
The value of the probability for the 3pl model.
}
\description{
The probability function in the 3PL model.
}
\examples{
## Simulate the test
# data <- simulateTest(model = "3PL", items = 20, individuals = 200)
## item parameters
# zita <-data$itempars
## Latent traits
# thetas <- data$latentTraits
## Probability model
# probability.3pl(zita, theta = thetas)
}
\seealso{
\code{\link{probability.1pl}}, \code{\link{probability.2pl}}, 
\code{\link{prob.3pl}}, \code{\link{prob.2pl}}
}

