% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_chart.R
\name{plot_facets}
\alias{plot_facets}
\title{Plot Facets}
\usage{
plot_facets(
  coord,
  title = NULL,
  size = 1,
  file_name = "none",
  file_width = 10,
  file_height = 10,
  zoom_x = NULL,
  zoom_y = NULL,
  dpi = 500,
  color = "black",
  fade = 85,
  font = "sans",
  cor_labels = TRUE,
  size_title = 1,
  size_cor_labels = 1,
  size_test_label = 1,
  size_facet_labels = 1,
  width_axes = 1,
  width_circles = 1,
  width_tick = 1,
  size_tick_label = 1
)
}
\arguments{
\item{coord}{list generated by \code{\link{coord_facets}} or
\code{\link{coord_nested}}.}

\item{title}{character; overall chart title; defaults to NULL.}

\item{size}{integer; changes the size of most chart objects simultaneously.}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to
"none".}

\item{file_width}{integer; file width in inches; defaults to 10.}

\item{file_height}{integer; file height in inches; defaults to 10.}

\item{zoom_x}{integer; vector with two values, the edges of the zoomed
section on the x-axis; defaults to NULL.}

\item{zoom_y}{integer; vector with two values, the edges of the zoomed
section on the y-axis; defaults to NULL.}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{color}{accent color; defaults to "black".}

\item{fade}{integer; brightness of the gray tones between 0 = "black" and 100
= "white" in steps of 1; defaults to 85.}

\item{font}{character; text font, use extrafonts to access additional fonts;
defaults to "sans", which is "Helvetica".}

\item{cor_labels}{logical; if \code{TRUE}, shows latent correlations between
facets; defaults to \code{TRUE}.}

\item{size_title}{integer; title font size relative to default.}

\item{size_cor_labels}{integer; correlation font size relative to default.}

\item{size_test_label}{integer; test font size relative to default.}

\item{size_facet_labels}{integer; facet font size relative to default.}

\item{width_axes}{integer; radial axis width relative to default.}

\item{width_circles}{integer; facet circle outline width relative to default.}

\item{width_tick}{integer; axis tick line width relative to default.}

\item{size_tick_label}{integer; axis tick font size relative to default.}
}
\value{
Object of the class "ggplot".
}
\description{
Generates a facet chart from coordinates.
}
\details{
Use \code{\link{facet_chart}} to create facet charts.
}
\seealso{
\code{\link{coord_facets}} \code{\link{facet_chart}}
}
