#' Domain Specific Self-Esteem Inventory
#'
#' A set of center distances and latent correlations for items and facets of the
#' DSSEI, completed by 2272 german speaking participants using the german
#' version of the questionnaire. SEM estimation performed on the DSSEI data
#' alone (differing from the estimation in "self_confidence").
#'
#' @section Items:
#'
#'   __ Social Competence (So) __
#'
#'   1.  I usually feel as if I have handled myself well at social gatherings.
#'
#'   5.  I feel secure in social situations.
#'
#'   9.  I feel confident of my social behaviour.
#'
#'   13. I am often troubled with shyness. (R)
#'
#'   17. At social gatherings I am often withdrawn, not at all outgoing. (R)
#'
#'   __ Task-Related Abilities (Ab) __
#'
#'   2.  I feel as if I lack the necessary skills to really succeed at the work
#'   I do. (R)
#'
#'   6.  I am able to do things as well as most other people.
#'
#'   10. I usually expect to succeed at the things I do.
#'
#'   14. I almost always accomplish the goals I set for myself.
#'
#'   18. In general, I feel confident about my abilities.
#'
#'   __ Physical Appeal (Ph) __
#'
#'   3.  I feel that others would consider me to be attractive.
#'
#'   7.  I'm not as nice looking as most people. (R)
#'
#'   11. I feel confident that my physical appearance is appealing to others.
#'
#'   15. I am satisfied with the way I look.
#'
#'   19. I feel unattractive compared to most people my age. (R)
#'
#'   __ Public Presentation (Pb) __
#'
#'   4.  When I speak in a large group discussion, I usually feel sure of
#'   myself.
#'
#'   8.  I enjoy being in front of large audiences.
#'
#'   12. I feel quite confident when speaking before a group of my peers.
#'
#'   16. I find it very hard to talk in front of a group. (R)
#'
#'   20. When I talk in front of a group of people my own age, I am usually
#'   somewhat worried or afraid. (R)
#'
#'   (Hoyle, R. H. (1991). Evaluating measurement models in clinical research:
#'   Covariance structure analysis of latent variable models of self-conception.
#'   Journal of Consulting and Clinical Psychology, 59(1), 67.)
#'
#' @source Dantlgraber, M., Stieger, S., & Reips, U. D. (2019). Introducing Item
#'   Pool Visualization: A method for investigation of concepts in self-reports
#'   and psychometric tests. Methodological Innovations, 12(3),
#'   2059799119884283.
#'
"DSSEI"

#'Self-Confidence
#'
#'A set of center distances and latent correlations for items and facets of the
#'Domain Specific Self-Esteem Inventory (DSSEI), Sports Mental Toughness
#'Questionnaire (SMTQ), and Rosenberg Self-Esteem Scale (RSES) completed by 2272
#'german speaking participants using the german versions of the questionnaires.
#'SEM estimation performed for all tests as one item pool.
#'
#'
#'@section Items:
#'
#'  _____ RSES _____
#'
#'  __ Positive Self-Esteem (Ps) __
#'
#'  1. On the whole, I am satisfied with myself.
#'
#'  3. I feel that I have a number of good qualities.
#'
#'  4. I am able to do things as well as most other people.
#'
#'  7.I feel that I'm a person of worth.
#'
#'  10. I take a positive attitude toward myself.
#'
#'  __ Lack of Negative Self-Esteem (Ns) __
#'
#'  2. At times I think I am no good at all.
#'
#'  5. I feel I do not have much to be proud of.
#'
#'  6. I certainly feel useless at times.
#'
#'  8. I wish I could have more respect for myself.
#'
#'  9. All in all, I am inclined to think that I am a failure.
#'
#'  (Rosenberg, M. (1965). Rosenberg self-esteem scale (RSE). Acceptance and
#'  commitment therapy. Measures package, 61, 52.)
#'
#'  _____ SMTQ _____
#'
#'  \code{\link{SMTQ}}
#'
#'  _____ DSSEI _____
#'
#'  \code{\link{DSSEI}}
#'
#'@source Dantlgraber, M., Stieger, S., & Reips, U. D. (2019). Introducing Item
#'  Pool Visualization: A method for investigation of concepts in self-reports
#'  and psychometric tests. Methodological Innovations, 12(3), 2059799119884283.
#'
"self_confidence"


#' Sports Mental Toughness Questionnaire
#'
#' A set of center distances and latent correlations for items and facets of the
#' SMTQ, completed by 2272 german speaking participants using the german version
#' of the questionnaire. SEM estimation performed together with DSSEI and RSES
#' (same as in "self_confidence").
#'
#' @section Items:
#'
#'   __ Confidence (Cf) __
#'
#'   13. I interpret potential threats as positive opportunities
#'
#'   5.  I have an unshakeable confidence in my ability
#'
#'   11. I have qualities that set me apart from other competitors
#'
#'   6.  I have what it takes to perform well while under pressure
#'
#'   14. Under pressure, I am able to make decisions with confidence and
#'   commitment
#'
#'   1.  I can regain my composure if I have momentarily lost it
#'
#'   __ Constancy (Cs) __
#'
#'   3.  I am committed to completing the tasks I have to do
#'
#'   12. I take responsibility for setting myself challenging targets
#'
#'   8.  I give up in difficult situations
#'
#'   10. I get distracted easily and lose my concentration
#'
#'   __ Control (Ct) __
#'
#'   2.  I worry about performing poorly
#'
#'   4.  I am overcome by self-doubt
#'
#'   9.  I get anxious by events I did not expect or cannot control
#'
#'   7.  I get angry and frustrated when things do not go my way
#'
#'   (Sheard, M., Golby, J., & Van Wersch, A. (2009). Progress toward construct
#'   validation of the Sports Mental Toughness Questionnaire (SMTQ). European
#'   Journal of Psychological Assessment, 25(3), 186-193.)
#'
#' @source Dantlgraber, M., Stieger, S., & Reips, U. D. (2019). Introducing Item
#'   Pool Visualization: A method for investigation of concepts in self-reports
#'   and psychometric tests. Methodological Innovations, 12(3),
#'   2059799119884283.
#'
"SMTQ"
