% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/produce_e1d_report.R
\name{produce_e1d_report}
\alias{produce_e1d_report}
\title{Shortcut function with all steps to provide a 12 Month Enrollment report}
\usage{
produce_e1d_report(df, hrs, part = "ALL", format = "uploadable")
}
\arguments{
\item{df}{A dataframe set up according to the readme for students}

\item{hrs}{A dataframe set up according to the readme for instructional activity}

\item{part}{A string with what part of the report you want to produce: 'all', 'A', etc.}

\item{format}{A string (\code{"uploadable"} will produce a properly formatted
upload file. \code{"readable"} will produce a csv of the upload file (only
works for one part at a time). \code{"both"} will provide both options, but
only works with one part at a time.}
}
\value{
A txt or csv file at the path of your choice
}
\description{
Shortcut function with all steps to provide a 12 Month Enrollment report
}
\examples{
\dontshow{
#set temp directory for this example (not necessary for users)
.old_wd <- setwd(tempdir())
}

#entire report
produce_e1d_report(e1d_student, e1d_instr)

#one part, as csv instead of key-value file
produce_e1d_report(e1d_student, part = "A", format = "readable")

\dontshow{
#reset directory for this example (not necessary for users)
setwd(.old_wd)
}
}
