% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildfa.R
\name{build_fa}
\alias{build_fa}
\title{Build figural analogies.}
\usage{
build_fa(
  isomorphs = 1,
  main.rot = c(0, 0),
  mirror = 0,
  trap.rot = c(0, 0),
  subtract = c(0, 0),
  dot.mov = c(0, 0),
  a.main = "R",
  a.flip = "R",
  a.trap = "R",
  a.dot = "R",
  constrict = F,
  al.main.rot = 0,
  al.mirror = 0,
  al.trap.rot = 0,
  al.subtract = 0,
  al.dot.mov = 0,
  correct = 0,
  add.rule = 0,
  automatic = T
)
}
\arguments{
\item{isomorphs}{A number of isomorphic items to be developed.}

\item{main.rot}{A numeric vector with two main shape rotation values multiple of 45 and between -135 and 180. No rotation: 0.}

\item{mirror}{A number designating the presence of shape reflection or no reflection (i.e., 1 or 0).}

\item{trap.rot}{A numeric vector with two trapezium rotation values multiple of 45 and between -135 and 180. No rotation: 0.}

\item{subtract}{A numeric vector with two line segments of the main shape to subtract from 1 to 5, or letter \code{"R"} for a random subtraction. No subtraction: 0.}

\item{dot.mov}{A numeric vector with two dot edge movement amounts, with a maximum of 5 movements in total. No dot edge movement: 0.}

\item{a.main}{A numeric vector with possible rotation states of the main shape of Figure A from 1 to 8. Random by default.}

\item{a.flip}{A logical value designating whether Figure A is flipped with respect to its vertical axis or not (i.e., \code{T} or \code{F}). Random by default.}

\item{a.trap}{A numeric vector with possible rotation states of the trapezium of Figure A from 1 to 8. Random by default.}

\item{a.dot}{A numeric vector with possible dot positions in Figure A from 1 to 6. Random by default.}

\item{constrict}{A character string designating a part of Figure A to display all possible positions every 'n' isomorphs.}

\item{al.main.rot}{A numeric vector with alternative main shape rotation solutions. Random by default.}

\item{al.mirror}{A numeric vector with alternative reflection solutions. Random by default.}

\item{al.trap.rot}{A numeric vector with alternative trapezium rotation solutions. Random by default.}

\item{al.subtract}{A numeric vector with alternative subtraction solutions. Random by default.}

\item{al.dot.mov}{A numeric vector with alternative dot edge movement solutions. Random by default.}

\item{correct}{A vector with numbers ranging from 1 to 9 for correct response placements. Random by default.}

\item{add.rule}{A number specifying which rule from 1 to 5 adds itself to the options of one-rule-based items. Random by default.}

\item{automatic}{Should options be generated by the program? True by default.}
}
\value{
An object of class \code{'fa_items'}, basically a list including elements to be plotted with function \code{\link{plot_fa}}.
}
\description{
\code{build_fa} generates the information of figural analogies
that can be read by \code{\link{plot_fa}}.
}
\details{
Thorough information about the \code{build_fa} function can be found in the cited
research paper of Blum and Holling (2018). Make sure to read the PDF version of it,
since it is clearer. Additional information can also be found on icar-project.com.
}
\examples{
## Create two isomorphs with one rule, and set the correct answer to 1:
one <- build_fa(isomorphs = 2, dot.mov = c(1, 2), correct = 1)
## For plotting options, see the plot_fa examples.

## Create four isomorphs with two rules:
two <- build_fa(isomorphs = 4, main.rot = c(180, 135), trap.rot = c(90, 45))
## For plotting options, see the plot_fa examples.

## Create 20 isomorphs with three rules. Set automatic = FALSE and affect the options:
three <- build_fa(isomorphs = 20, mirror = 1, trap.rot = c(90, 45), dot.mov = c(1, 2),
automatic = FALSE, al.mirror = c(0, 1), al.trap.rot = -45, al.dot.mov = 1)
## For plotting options, see the plot_fa examples.

## Create and plot four two-rule-based isomorphs, all of them comprising the same Figure A:
four <- build_fa(isomorphs = 4, a.main = 1, a.flip = FALSE, a.trap = 2, a.dot = 6,
mirror = 1, subtract = "R")
## For plotting options, see the plot_fa examples.

## Create and plot 16 isomorphs by constricting the main shape rotation rule:
five <- build_fa(isomorphs = 16, subtract = c(1, 4), constrict = "main")
## For plotting options, see the plot_fa examples.
}
\references{
Blum, D., & Holling, H. (2018). Automatic generation of figural analogies with the IMak package. \emph{Frontiers in psychology, 9}(1286), 1-13. <DOI:10.3389/fpsyg.2018.01286>
}
\seealso{
\code{\link{plot_fa}}
}
\author{
Diego Blum \email{blumworx@gmail.com}
}
