% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent.R
\name{calculate_extent}
\alias{calculate_extent}
\title{Extent}
\usage{
calculate_extent(data, var, higher_level_geography, population)
}
\arguments{
\item{data}{Data frame containing a variable to be aggregated, lower level
geography population estimates, and a higher level geographical
grouping variable}

\item{var}{Name of the variable in the data frame containing the variable to
be aggregated (e.g. rank) for the lower level geography}

\item{higher_level_geography}{Name of the variable in the data frame
containing the higher level geography names/codes}

\item{population}{Name of the variable in the data frame containing
the population estimates of the lower level geography}
}
\description{
\code{extent} calculates 'extent' scores when aggregating up small areas.
}
\details{
"Extent" is the proportion of the local population that live in areas
classified as among the most deprived in the higher geography. The
calculation of extent is taken from the IMD technical report Appendix N:

"The population living in the most deprived 11 to 30 per cent of Lower-layer
Super Output Areas receive a sliding weight, ranging from 0.95 for those in
the most deprived eleventh percentile, to 0.05 for those in the most deprived
thirtieth percentile. In practice this means that the weight starts from 0.95
in the most deprived eleventh percentile, and then decreases by
(0.95-0.05)/19 for each of the subsequent nineteen percentiles until it
reaches 0.05 for the most deprived thirtieth percentile, and zero for areas
outside the most deprived 30 per cent"
}
