% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs1.R
\name{qs1}
\alias{qs1}
\title{Power of spatial and multilevel discretization determinant (PSMD)
of SPADE model for an individual explanatory variable.}
\usage{
qs1(y, x, xh, location)
}
\arguments{
\item{y}{A numeric vector of a response variable}

\item{x}{A numeric vector of a explanatory variable}

\item{xh}{A character variable of an explanatory variable}

\item{location}{A matrix of spatial locations}
}
\value{
A data frame of PSMD values.
}
\description{
Power of spatial and multilevel discretization determinant (PSMD)
of SPADE model for an individual explanatory variable.
}
\examples{
library(GD)
data.disc <- disc(sim$xa, 4, "quantile")
xh <- cut(sim$xa, data.disc$itv, include.lowest = TRUE)
qs1(y = sim$y, x = sim$xa, xh = xh, location = sim[, c("lo","la")])

}
