% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_noncomp_inhibition}
\alias{FIM_noncomp_inhibition}
\title{Fisher information matrix for the noncompetitive inhibition Michaelis-Menten model.}
\usage{
FIM_noncomp_inhibition(S, I, w, param)
}
\arguments{
\item{S}{vector of \code{S} component of design points. \code{S} is the substrate concentration.}

\item{I}{vector of \code{I} component of design points. \code{I} is the inhibitor concentration.}

\item{w}{vector of corresponding weights for each design point. Its length must be equal to the length of \code{I} and \code{S}, and \code{sum(w)} should be 1.}

\item{param}{vector of model parameters \eqn{(V, K_m, K_{ic})}{(V, Km, Kic)}.}
}
\value{
Fisher information matrix.
}
\description{
The mean velocity of the reaction rate is
 \deqn{\eta = \frac{VS}{(K_m + S)(1 + \frac{I}{K_{ic}})}.}{\eta = VS/(Km + S)(1 + I/Kic).}
  Here, \eqn{S} is the substrate concentration, \eqn{I} is the inhibitor concentration,
   \eqn{V} is the maximum velocity of the enzyme,
    \eqn{K_{ic}}{Kic} is the dissociation constants and \eqn{K_m}{Km} is the Michaelis-Menten constant.
     Any design point is of the form \eqn{(S, I)}.
}
\details{
The model has an analytical solution for the locally D-optimal design. See Bogacka et al. (2011) for details.\cr
The optimal design does not depend on parameter \eqn{V}.
}
\references{
Bogacka, B., Patan, M., Johnson, P. J., Youdim, K., & Atkinson, A. C. (2011). Optimum design of experiments for enzyme inhibition kinetic models. Journal of biopharmaceutical statistics, 21(3), 555-572.
}
\seealso{
Other FIM: \code{\link{FIM_comp_inhibition}},
  \code{\link{FIM_emax_3par}}, \code{\link{FIM_exp_2par}},
  \code{\link{FIM_exp_3par}},
  \code{\link{FIM_logisitic_1par}},
  \code{\link{FIM_logistic_4par}},
  \code{\link{FIM_logistic}}, \code{\link{FIM_loglin}},
  \code{\link{FIM_michaelis}},
  \code{\link{FIM_mixed_inhibition}},
  \code{\link{FIM_power_logistic}},
  \code{\link{FIM_uncomp_inhibition}}
}

