% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSummary.R
\name{per_facility_summary}
\alias{per_facility_summary}
\title{Function that extracts summary statistics from entire database}
\usage{
per_facility_summary(base, verbose = FALSE, ...)
}
\arguments{
\item{base}{(data.table).
A subject discharge database, in the form of a data.table. The data.table should have at least the following columns:
    sID: subjectID (character)
    fID: facilityID (character)
    Adate: admission date (date)
    Ddate: discharge date (date)}

\item{verbose}{(boolean) print diagnostic messages. Default is TRUE.}

\item{...}{other parameters passed on to internal functions}
}
\value{
a data table with one row per facility, showing mean LOS, number of subjects, and number of admissions
}
\description{
Function that extracts summary statistics from entire database
}
\examples{
mydb <- create_fake_subjectDB(n_subjects = 100, n_facilities = 10)
myBase <- checkBase(mydb)
per_facility_summary(myBase)
}
