% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\docType{methods}
\name{checkEmptyBins}
\alias{checkEmptyBins}
\alias{checkEmptyBins,distributionH-method}
\title{Method \code{checkEmptyBins}}
\usage{
checkEmptyBins(object)

\S4method{checkEmptyBins}{distributionH}(object)
}
\arguments{
\item{object}{a \code{distributionH} object}
}
\value{
A \code{distributionH} object without empty bins
}
\description{
Method \code{checkEmptyBins}

The method checking for empty bins in a distribution, i.e. if two cdf consecutive
values are equal. In that case a probability value of \code{1e-7} is
assigned to the empty bin and the cdf is recomputed. This methods is useful
for numerical reasons.
}
\examples{
##---- A mydist distribution with an empty bin i.e. two consecutive values of p are equal----
mydist<-distributionH(x=c(1,2,3,10), p=c(0,0.5,0.5,1))
##---- Checks for empty byns and returns the newdist object without empty bins ----
newdist<-checkEmptyBins(mydist)
}
\author{
Antonio Irpino
}
\keyword{distribution}

