% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/HighDimOut.R
\name{Func.trans}
\alias{Func.trans}
\title{Outlier score transformation}
\usage{
Func.trans(raw.score, method)
}
\arguments{
\item{raw.score}{is the scores returned by each method}

\item{method}{should be a character specifying  the method used to generate the raw score. It has 3 possible values, "ABOD", "SOD", and "FBOD".}
}
\value{
The function returns the transformed outlier scores
}
\description{
This function calculate the transformed outlier scores, with the aim of unifying the results from different methods.
The method is based on the work of Kriegel, H.P., Kroger, P., Schubert, E., Zimek, A., Interpreting and unifying outlier scores, 2011.
It consists of two steps, regularization and normalization.
For the ABOD scores, logarithmic inversion is used for regularization
For the SOD scores, no action is taken to perform regularization
For the FBOD method, the basic regularization, i.e., score-1, is used for regularization
For the normalization step, the gaussian scaling method is used.
The final output can be interpreted as the outlier probability, ranging from 0 to 1.
}

