% Generated by roxygen2 (4.0.1): do not edit by hand
\name{p.value}
\alias{p.value}
\title{Extract just the P value(s) from a Hardy-Weinberg test.}
\usage{
p.value(x, statName = NA)
}
\arguments{
\item{x}{The result of a call to \code{\link{hwx.test}} or a list of such results. It can also be the genotype counts in any of the same formats as accepted by \code{\link{hwx.test}}}

\item{statName}{can be \dQuote{LLR}, \dQuote{Prob}, \dQuote{U}, or \dQuote{Chisq}}
}
\value{
The P value
}
\description{
Use the \code{p.value} function to return just the P value(s) from the results of a call to \code{\link{hwx.test}}. If applied to a list of results, it will return a vector or matrix of P values. You can specify the \code{statName} as \dQuote{LLR}, \dQuote{Prob}, \dQuote{U} or \dQuote{Chisq}. You can also apply \code{p.value} to a matrix or vector and it will attempt to use \code{\link{hwx.test}} to return a P value. However, it's usually preferable to use \code{\link{hwx.test}} directly.
}
\examples{
data(HWcases)
testResults <- hwx.test(HWcases)
p.value(testResults)
p.value(testResults, statName="U")
}
\references{
The methods are described by \href{http://dx.doi.org/10.1534/genetics.109.108977}{Engels, 2009. \bold{Genetics} 183:1431}.
}

