/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class XmlException
extends Exception {
    private String _message;
    private Throwable _cause;
    private String _systemId;
    private int _line = -1;
    private int _column = -1;

    public XmlException(String message, String systemId) {
        this(message, systemId, -1, -1, null);
    }

    public XmlException(String message, String systemId, int line, int column) {
        this(message, systemId, line, column, null);
    }

    public XmlException(String message, String systemId, int line, int column, Throwable cause) {
        this._message = message;
        this._systemId = systemId;
        this._line = line;
        this._column = column;
        this._cause = cause;
    }

    public Throwable getCause() {
        return this._cause;
    }

    public String getMessage() {
        return this._message + " in " + this._systemId + (this._line == -1 ? "unknown line " : " at line " + this._line) + (this._column == -1 ? " and unknown column " : " and column " + this._column) + (this._cause == null ? "" : "\nCaused by:\n " + this._cause);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public int getLine() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err));
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this._cause != null) {
            printWriter.print("Caused by: ");
            this._cause.printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

