/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFormatter;
import ptolemy.util.StringUtilities;

public class PlotFrame
extends JFrame {
    public PlotBox plot;
    protected JMenuBar _menubar = new JMenuBar();
    protected JMenu _editMenu = new JMenu("Edit");
    protected JMenu _fileMenu = new JMenu("File");
    protected JMenu _specialMenu = new JMenu("Special");
    protected File _directory = null;
    protected File _file = null;

    public PlotFrame() {
        this("Ptolemy Plot Frame");
    }

    public PlotFrame(String string) {
        this(string, (PlotBox)null);
    }

    public PlotFrame(String string, PlotBox plotBox) {
        super(string);
        this.plot = plotBox == null ? new Plot() : plotBox;
        this.plot.setBackground(new Color(0xE5E5E5));
        this._fileMenu.setMnemonic(70);
        this._editMenu.setMnemonic(69);
        this._specialMenu.setMnemonic(83);
        JMenuItem[] jMenuItemArray = new JMenuItem[]{new JMenuItem("Open", 79), new JMenuItem("Save", 83), new JMenuItem("SaveAs", 65), new JMenuItem("Export", 69), new JMenuItem("Print", 80), new JMenuItem("Close", 67)};
        jMenuItemArray[0].setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItemArray[1].setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItemArray[4].setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItemArray[5].setAccelerator(KeyStroke.getKeyStroke(87, 2));
        FileMenuListener fileMenuListener = new FileMenuListener();
        for (int i = 0; i < jMenuItemArray.length; ++i) {
            jMenuItemArray[i].setActionCommand(jMenuItemArray[i].getText());
            jMenuItemArray[i].addActionListener(fileMenuListener);
            this._fileMenu.add(jMenuItemArray[i]);
        }
        this._menubar.add(this._fileMenu);
        JMenuItem jMenuItem = new JMenuItem("Format", 70);
        FormatListener formatListener = new FormatListener();
        jMenuItem.addActionListener(formatListener);
        this._editMenu.add(jMenuItem);
        this._menubar.add(this._editMenu);
        JMenuItem[] jMenuItemArray2 = new JMenuItem[]{new JMenuItem("About", 65), new JMenuItem("Help", 72), new JMenuItem("Clear", 67), new JMenuItem("Fill", 70), new JMenuItem("Reset axes", 82), new JMenuItem("Sample plot", 83)};
        SpecialMenuListener specialMenuListener = new SpecialMenuListener();
        for (int i = 0; i < jMenuItemArray2.length; ++i) {
            jMenuItemArray2[i].setActionCommand(jMenuItemArray2[i].getText());
            jMenuItemArray2[i].addActionListener(specialMenuListener);
            this._specialMenu.add(jMenuItemArray2[i]);
        }
        this._menubar.add(this._specialMenu);
        this.setJMenuBar(this._menubar);
        this.getContentPane().add((Component)this.plot, "Center");
        this.setSize(500, 300);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    public void samplePlot() {
        this._file = null;
        this._directory = null;
        this.plot.samplePlot();
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotFrame class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.3, Build: $Id: PlotFrame.java,v 1.64 2003/04/12 10:49:33 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2003, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _close() {
        this.dispose();
    }

    protected void _editFormat() {
        PlotFormatter plotFormatter = new PlotFormatter(this.plot);
        plotFormatter.openModal();
    }

    protected void _export() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new EPSFileFilter());
        jFileChooser.setDialogTitle("Export EPS to...");
        if (this._directory != null) {
            jFileChooser.setCurrentDirectory(this._directory);
        } else {
            String string = StringUtilities.getProperty("user.dir");
            if (string != null) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
        }
        jFileChooser.setSelectedFile(new File(jFileChooser.getCurrentDirectory(), "plot.eps"));
        int n = jFileChooser.showDialog(this, "Export");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.plot.export(fileOutputStream);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error exporting plot: " + iOException, "Ptolemy II Error", 2);
            }
        }
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotFrame is a plot in a top-level window.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.", "About Ptolemy Plot", 1);
    }

    protected void _open() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select a plot file");
        jFileChooser.addChoosableFileFilter(new PLTOrXMLFileFilter());
        if (this._directory != null) {
            jFileChooser.setCurrentDirectory(this._directory);
        } else {
            String string = StringUtilities.getProperty("user.dir");
            if (string != null) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
        }
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this._file = jFileChooser.getSelectedFile();
            this.setTitle(this._file.getName());
            this._directory = jFileChooser.getCurrentDirectory();
            try {
                this.plot.clear(true);
                this._read(new URL("file", null, this._directory.getAbsolutePath()), new FileInputStream(this._file));
                this.plot.repaint();
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, "File not found:\n" + fileNotFoundException.toString(), "Ptolemy Plot Error", 2);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error reading input:\n" + iOException.toString(), "Ptolemy Plot Error", 2);
            }
        }
    }

    protected void _print() {
        this._printCrossPlatform();
    }

    protected void _printCrossPlatform() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.plot);
        if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
            try {
                printerJob.print(hashPrintRequestAttributeSet);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Printing failed:\n" + exception.toString(), "Print Error", 2);
            }
        }
    }

    protected void _printNative() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.plot);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Printing failed:\n" + exception.toString(), "Print Error", 2);
            }
        }
    }

    protected void _read(URL uRL, InputStream inputStream) throws IOException {
        this.plot.read(inputStream);
    }

    protected void _save() {
        if (this._file != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this._file);
                this.plot.write(fileOutputStream);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error writing file:\n" + iOException.toString(), "Ptolemy Plot Error", 2);
            }
        } else {
            this._saveAs();
        }
    }

    protected void _saveAs() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new PLTOrXMLFileFilter());
        jFileChooser.setDialogTitle("Save plot as...");
        if (this._directory != null) {
            jFileChooser.setCurrentDirectory(this._directory);
        } else {
            String string = StringUtilities.getProperty("user.dir");
            if (string != null) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
        }
        jFileChooser.setSelectedFile(new File(jFileChooser.getCurrentDirectory(), "plot.xml"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this._file = jFileChooser.getSelectedFile();
            this.setTitle(this._file.getName());
            this._directory = jFileChooser.getCurrentDirectory();
            this._save();
        }
    }

    class PLTOrXMLFileFilter
    extends FileFilter {
        PLTOrXMLFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(n);
            if (string2 != null) {
                return string2.equalsIgnoreCase(".plt") || string2.equalsIgnoreCase(".xml");
            }
            return false;
        }

        public String getDescription() {
            return ".plt and .xml files";
        }
    }

    class EPSFileFilter
    extends FileFilter {
        EPSFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(n);
            if (string2 != null) {
                return string2.equalsIgnoreCase(".eps");
            }
            return false;
        }

        public String getDescription() {
            return "Encapsulated PostScript (.eps) files";
        }
    }

    class SpecialMenuListener
    implements ActionListener {
        SpecialMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            try {
                if (string.equals("About")) {
                    PlotFrame.this._about();
                } else if (string.equals("Help")) {
                    PlotFrame.this._help();
                } else if (string.equals("Fill")) {
                    PlotFrame.this.plot.fillPlot();
                } else if (string.equals("Reset axes")) {
                    PlotFrame.this.plot.resetAxes();
                } else if (string.equals("Clear")) {
                    PlotFrame.this.plot.clear(false);
                    PlotFrame.this.plot.repaint();
                } else if (string.equals("Sample plot")) {
                    PlotFrame.this.plot.clear(true);
                    PlotFrame.this.samplePlot();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Special Menu Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotFrame.this.repaint();
        }
    }

    class FormatListener
    implements ActionListener {
        FormatListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PlotFrame.this._editFormat();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Format Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotFrame.this.repaint();
        }
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            try {
                if (string.equals("Open")) {
                    PlotFrame.this._open();
                } else if (string.equals("Save")) {
                    PlotFrame.this._save();
                } else if (string.equals("SaveAs")) {
                    PlotFrame.this._saveAs();
                } else if (string.equals("Export")) {
                    PlotFrame.this._export();
                } else if (string.equals("Print")) {
                    PlotFrame.this._print();
                } else if (string.equals("Close")) {
                    PlotFrame.this._close();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "File Menu Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotFrame.this.repaint();
        }
    }
}

