% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likint3.r
\name{likint3}
\alias{likint3}
\title{Calculate density function and integrate between limits}
\usage{
likint3(w, wsd, minT, maxT)
}
\arguments{
\item{w}{is an array of grid values like sea surface temperature}

\item{wsd}{is an array containing the sd of the grid values, usually from \code{raster::focal}}

\item{minT}{is an integer representing the lower limit of the tag-measured variable (e.g. SST)}

\item{maxT}{is an integer representing the upper limit of the tag-measured variable}
}
\value{
an array of dim(w) that represents the likelihood of the tag-measured variable as compared to the input grid
}
\description{
#' \code{likint3} calculates density function for a normal distribution and integrates between limits
}
\examples{
# Dummy example environmental grid
env.grid <- matrix(seq(1,100,by=1), ncol=10)

# Generates likelihood of measurement
# as compared to environmental grid
likint3(env.grid, 2, 55, 70)
}
