% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.utility.R
\name{specific.annotation.matrix}
\alias{specific.annotation.matrix}
\title{Specific annotation matrix}
\usage{
specific.annotation.matrix(file = "gene2pheno.txt.gz")
}
\arguments{
\item{file}{text file representing the associations gene-OBO terms. The file must be written as sequence of rows.
Each row represents a gene/protein and all its associations with an ontology term (pipe separated), i.e. in the form \emph{e.g.: gene1 |obo1|obo2|...|oboN}.}
}
\value{
The annotation matrix of the most specific annotations (0/1): rows are genes and columns are functional terms (such as GO or HPO).
Let's denote \eqn{M} the labels matrix. If \eqn{M[i,j]=1}, means that the gene \eqn{i} is annotated with the class \eqn{j}, otherwise \eqn{M[i,j]=0}.
}
\description{
Build the annotation matrix of the most specific functional terms.
}
\details{
The input plain text file (representing the associations gene-OBO terms) can be obtained by cloning the GitHub repository
\href{https://github.com/marconotaro/obogaf-parser}{obogaf-parser}, a perl5 module specifically designed to handle HPO and GO obo file and
their gene annotation file (gaf file).
}
\examples{
gene2pheno <- system.file("extdata/gene2pheno.txt.gz", package="HEMDAG");
spec.ann <- specific.annotation.matrix(file=gene2pheno);
}
