% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aeS.R
\name{aeS}
\alias{aeS}
\title{Quantile of the absolute values of Gaussian vectors with long run covariance}
\usage{
aeS(ft, Sn, W, M, alpha)
}
\arguments{
\item{ft}{The input multivariate time series}

\item{Sn}{Long run covariance matrix}

\item{W}{The inverse of covariance matrix at lag 0}

\item{M}{Number of Gaussian vectors sampled for computing empirical quantile}

\item{alpha}{level of significance (default 0.05)}
}
\value{
alpha-level quantiles for testing whether the input multivariate time series is a white noise or not, alpha is 0.05
}
\description{
This is an auxillary function to compute alpha-level quantile of absolute values of Gaussian vectors whose covariance matrices are specified by W.
}
\details{
For input multivariate time series \eqn{\varepsilon_t}, derive
\deqn{f_t=\{vec(\varepsilon_{t+1}\varepsilon_t^T),\ldots,vec(\varepsilon_{t+K}\varepsilon_t^T)\}^T}. Long run covariance matrix
\eqn{S_n} is estimated separately using the method described in Section 2.3 in the reference below and inverse
covariance matrix at lag \eqn{0} is estimated using \eqn{\varepsilon_t}. \eqn{M} independent Gaussian vectors with desired long run covariance are sampled to
compute the \eqn{\alpha}-level empirical quantiles for their absolute values.
}
\author{
Meng Cao, Wen Zhou
}
\references{
J. Chang, Q. Yao, and W. Zhou (2016) Testing for high-dimensional white noise using maximum cross correlations. \emph{Biometrika}, to appear.
}

