% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_weights_portfol.R
\name{new_MV_portfolio_weights_BDOPS21}
\alias{new_MV_portfolio_weights_BDOPS21}
\title{Constructor of MV portfolio object}
\usage{
new_MV_portfolio_weights_BDOPS21(x, gamma, b, beta)
}
\arguments{
\item{x}{a p by n matrix or a data frame of asset returns. Rows represent different
assets, columns -- observations.}

\item{gamma}{a numeric variable. Coefficient of risk aversion.}

\item{b}{a numeric variable. The target for weight shrinkage.}

\item{beta}{a numeric variable. The confidence level for weight intervals.}
}
\value{
an object of class MeanVar_portfolio with subclass MV_portfolio_weights_BDOPS21.\tabular{ll}{
   Element \tab Description \cr
   call \tab the function call with which it was created \cr
   cov_mtrx \tab the sample covariance matrix of the asset returns \cr
   inv_cov_mtrx \tab the inverse of the sample covariance matrix \cr
   means \tab sample mean vector estimate of the asset returns \cr
   W_mv_hat \tab sample estimate of the portfolio weights \cr
   weights \tab shrinkage estimate of the portfolio weights \cr
   alpha \tab shrinkage intensity for the weights \cr
   Port_Var \tab portfolio variance \cr
   Port_mean_return \tab expected portfolio return \cr
   Sharpe \tab portfolio Sharpe ratio \cr
   weight_intervals \tab A data frame \cr
}


weight_intervals contains a shrinkage estimate of portfolio weights,
asymptotic confidence intervals for the true portfolio weights, value of test
statistic and a p-value of the test on the equality of the weight of each individual
asset to zero (see Section 4.3 of Bodnar, Dette, Parolya and Thorsen 2021).
}
\description{
Constructor of mean-variance shrinkage portfolios. For more details of the method,
see \code{\link{MVShrinkPortfolio}}.
}
\examples{
# Assets with a diagonal covariance matrix

n<-3e2 # number of realizations
p<-.5*n # number of assets
b<-rep(1/p,p)
gamma<-1

x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

test <- new_MV_portfolio_weights_BDOPS21(x=x, gamma=gamma, b=b, beta=0.05)
summary(test)

# Assets with a non-diagonal covariance matrix

Mtrx <- RandCovMtrx(p=p)
x <- t(MASS::mvrnorm(n=n , mu=rep(0,p), Sigma=Mtrx))

test <- new_MV_portfolio_weights_BDOPS21(x=x, gamma=gamma, b=b, beta=0.05)
str(test)
}
\references{
\insertRef{BDOPS2021}{HDShOP}

\insertRef{BDNT21}{HDShOP}
}
