% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SM.R
\name{SM}
\alias{SM}
\title{Sample size in terms of number of subjects in the experimental group}
\usage{
SM(time, event, d2max, opt = "KM", event_ind, ta, tf, delta)
}
\arguments{
\item{time}{event time vector from person level historical control data.}

\item{event}{numeric vector indicating the status of event from person level historical control data.}

\item{d2max}{maximum number of events in the experimental group calculated from the design function.}

\item{opt}{the method of fitting survival curve-"log_normal" or "KM" (log-normal or Kaplan Meier). Default is "KM".}

\item{event_ind}{numeric value indicating the occurrence of event.}

\item{ta}{enrollment time.}

\item{tf}{follow-up time.}

\item{delta}{hazard ratio.}
}
\value{
Returns the value of sample size.
}
\description{
Calculates the total number of subjects for the experimental group using the total number of events(d2max:the output from design functions) and the estimated failure probability based on the person level historical control data and proportional hazard assumption.
}
\examples{
time<-c(20,65,12,50,58,65,45,44)
event<-c(1,0,0,0,1,1,1,1)
d2max=57
gg<-SM(time,event,d2max,opt="log_normal",ta=4,tf=3,delta=0.57,event_ind=1)
}
\references{
\insertRef{doi:10.1002/pst.1756}{HCTDesign}

\insertRef{doi:10.1080/10543406.2019.1684305}{HCTDesign}
}
\author{
Tushar Patni, Yimei Li, Jianrong Wu, and Arzu Onar-Thomas.
}
