% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GxEScanR.R
\name{gweis}
\alias{gweis}
\title{gweis}
\usage{
gweis(data, bdinfo, snps, outfile, skipfile, minmaf, blksize, binary)
}
\arguments{
\item{data}{Data frame containing the subject ID, phenotype
and covariates}

\item{bdinfo}{Information about the binary dosage file returned
from the BinaryDosage::getbdinfo routine}

\item{snps}{The SNPs to be used in the scan. This may be an integer
vector indicate which SNPs to use in the binary dosage file or a 
character vector of the SNP IDs to use. The value may also be "all",
indicating to use all SNPs. The default value is "all".}

\item{outfile}{The file name for the results Can be blank.
If the value is "", the results are returned as a data frame. Default
value is ""}

\item{skipfile}{The name of the file to write the SNPs that were not
used and the reason they weren't used. If the value is blank, there is
no output of the unused SNPs. Default value is "".}

\item{minmaf}{Minimum minor allele frequency of SNPs to include
in analysis. SNPS that have less than 20 minor alleles observed
will be excluded from the analysis regardless of the value of
minmaf. A value of 0 indicates to use all the SNPs that have 20
minor alleles observed. Default value is 0.}

\item{blksize}{Size of blocks of SNPs to read in at one time.
Larger blocks can improve overall speed but require larger
amounts of computer memory. A value of 0 indicates to use the
recommended block size. Default value is 0.}

\item{binary}{Logical value indicating if the phenotype
is a binary value. Default value is false.}
}
\value{
0
}
\description{
Run a gweis using genetic data from a binary dosage file
}
\examples{
bdinfo <- readRDS(system.file("extdata/pdata_4_1.bdinfo", package = "GxEScanR"))
covdata <- readRDS(system.file("extdata/covdata.rds", package = "GxEScanR"))

results <- gweis(data = covdata, bdinfo = bdinfo)
}
