% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_match_search.R
\name{initBinaryMatchExperimentalDesignSearch}
\alias{initBinaryMatchExperimentalDesignSearch}
\title{Begin a Binary Match Search}
\usage{
initBinaryMatchExperimentalDesignSearch(
  binary_match_structure,
  max_designs = 1000,
  wait = FALSE,
  start = TRUE,
  num_cores = 1,
  seed = NULL,
  prop_flips = 1
)
}
\arguments{
\item{binary_match_structure}{The \code{binary_experimental_design} object where the pairs are computed.}

\item{max_designs}{How many random allocation vectors you wish to return. The default is 1000.}

\item{wait}{Should the \code{R} terminal hang until all \code{max_designs} vectors are found? The 
default is \code{FALSE}.}

\item{start}{Should we start searching immediately (default is \code{TRUE}).}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}

\item{seed}{The set to set for deterministic output. This should only be set if \code{num_cores = 1} otherwise
the output will not be deterministic. Default is \code{NULL} for no seed set.}

\item{prop_flips}{Proportion of flips. Default is all. Lower for more correlated assignments (useful for research only).}
}
\description{
This method creates an object of type pairwise_matching_experimental_design_search and will immediately initiate
a search through $1_{T}$ space for pairwise match designs based on the structure computed in the function \code{computeBinaryMatchStructure}. 
For debugging, you can use set the \code{seed} parameter and \code{num_cores = 1} to be assured of deterministic output.
}
\author{
Adam Kapelner
}
