/*
 * Decompiled with CFR 0.152.
 */
package ObjectiveFunctions;

import ObjectiveFunctions.ObjectiveFunction;

public class KernelObjective
extends ObjectiveFunction {
    private double[][] Kgram;
    protected int[] indicT;
    private int n;

    public KernelObjective(double[][] dArray) {
        this.Kgram = dArray;
        this.n = dArray.length;
    }

    @Override
    public double calc(boolean bl) {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                d += this.Kgram[i][j] * (double)this.indicT[i] * (double)this.indicT[j];
            }
        }
        d *= (double)(4 / this.n ^ 2);
        if (bl) {
            System.out.println("kernel_sum: " + d);
        }
        return d;
    }

    public void setIndicT(int[] nArray) {
        int n = nArray.length;
        this.indicT = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indicT[i] = nArray[i] == 1 ? 1 : -1;
        }
    }
}

