% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoMiner.R
\name{GoMiner}
\alias{GoMiner}
\title{GoMiner}
\usage{
GoMiner(
  title = NULL,
  dir,
  sampleList,
  GOGOA3,
  ONT,
  enrichThresh = 2,
  countThresh = 5,
  fdrThresh = 0.1,
  nrand = 100
)
}
\arguments{
\item{title}{character string descriptive title}

\item{dir}{character string full pathname to the directory acting result repository}

\item{sampleList}{character list of gene names}

\item{GOGOA3}{return value of subsetGOGOA()}

\item{ONT}{character string c("molecular_function", "cellular_component", "biological_process")}

\item{enrichThresh}{numerical acceptance threshold for enrichment}

\item{countThresh}{numerical acceptance threshold for gene count}

\item{fdrThresh}{numerical acceptance threshold for fdr}

\item{nrand}{numeric number of randomizations to compute FDR}
}
\value{
returns a matrix suitable to generate a heatmap
}
\description{
driver to generate heatmap
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO
load("~/GODB_RDATA/GOGOA3.RData")
load("data/cluster52.RData")
l<-GoMiner("Cluster52",tempdir(),cluster52,
 GOGOA3,ONT="biological_process",enrichThresh=2,
 countThresh=5,fdrThresh=0.10,nrand=10)
}

}
