% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_spread.R
\name{spread}
\alias{spread}
\alias{spreadVertical}
\alias{spreadHorizontal}
\title{Spread boxes}
\usage{
spreadVertical(..., .from = NULL, .to = NULL, .type = c("between", "center"))

spreadHorizontal(..., .from = NULL, .to = NULL, .type = c("between", "center"))
}
\arguments{
\item{...}{A set of boxes to spread. Can also be a \code{list} of boxes.}

\item{.from}{A box that the spread originates from. If left empty the entire \code{viewport} will be used.}

\item{.to}{A box that the spread ends at. If left empty the entire \code{viewport} will be used.}

\item{.type}{If \code{between} the space between the boxes will be identical while
\code{center} has each box's center is equally distributed.}
}
\value{
\code{list} with the boxes that have been spread
}
\description{
Spreads a set of \code{\link{boxGrob}}/\code{\link{boxPropGrob}} in either horizontal or vertical direction.
}
\examples{
library(grid)
grid.newpage()

box1 <- boxGrob("B1", x = .2, y = .8)
box2 <- boxGrob("B2\n\n\neach\nbox\neven\nspace\nbetween", x = .2, y = .8)
box3 <- boxGrob("B3", x = .2, y = .8)
box4 <- boxGrob("B4", x = .2, y = .8)
box5 <- boxGrob("B5", x = .2, y = .8)

spread_boxes <- spreadVertical(box1,
                               box2,
                               box3,
                               a = box4,
                               box5, 
                               .type = "between")
for (b in spread_boxes) {
  print(b)
}

box1 <- boxGrob("B1\n\nanother group\ncenter oriented", x = .6, y = .8)
box2 <- boxGrob("B2", x = .6, y = .8)
box3 <- boxGrob("B3", x = .6, y = .8)
box4 <- boxGrob("B4", x = .6, y = .8)
box5 <- boxGrob("B5", x = .6, y = .8)

spread_boxes <- spreadVertical(box1,
                               box2,
                               box3,
                               a = box4,
                               box5, 
                               .type = "center")
for (b in spread_boxes) {
  print(b)
}
}
\seealso{
Other flowchart components: 
\code{\link{align}},
\code{\link{boxGrob}()},
\code{\link{boxPropGrob}()},
\code{\link{connectGrob}()},
\code{\link{coords}()},
\code{\link{distance}()},
\code{\link{moveBox}()}
}
\concept{flowchart components}
