% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptionStats.R
\name{describeMedian}
\alias{describeMedian}
\title{A function that returns a description median that contains
the interquartile range or the full range}
\usage{
describeMedian(x, iqr = TRUE, html = TRUE, digits = 1,
  digits.nonzero = NA, number_first = TRUE, useNA = c("ifany", "no",
  "always"), useNA.digits = digits, percentage_sign = TRUE,
  language = "en", ...)
}
\arguments{
\item{x}{The variable that you want the statistics for}

\item{iqr}{If interquartile range should be used}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting}

\item{digits}{The number of decimals used}

\item{digits.nonzero}{The number of decimals used for values that are close to zero}

\item{number_first}{If the number should be given or if the percentage
should be presented first. The second is encapsulated in parentheses ().
This is only used together with the useNA variable.}

\item{useNA}{This indicates if missing should be added as a separate
row below all other. See \code{\link[base]{table}} for \code{useNA}-options.
\emph{Note:} defaults to ifany and not "no" as \code{\link[base]{table}} does.}

\item{useNA.digits}{The number of digits to use for the
missing percentage, defaults to the overall \code{digits}.}

\item{percentage_sign}{If you want to suppress the percentage sign you
can set this variable to FALSE. You can also choose something else that
the default \% if you so wish by setting this variable. Note, this is
only used when combined with the missing information.}

\item{language}{The ISO-639-1 two-letter code for the language of
interest. Currently only english is distinguished from the ISO
format using a ',' as the separator in the \code{\link{txtInt}}
function.}

\item{...}{Passed on to \code{\link{describeFactors}}}
}
\value{
\code{string} A string formatted for either LaTeX or HTML
}
\description{
A function that returns a description median that contains
the interquartile range or the full range
}
\examples{
describeMedian(1:10)
describeMedian(c(1:10, NA), useNA="ifany")

}
\seealso{
\code{\link{getDescriptionStatsBy}}

Other descriptive functions: \code{\link{describeFactors}},
  \code{\link{describeMean}}, \code{\link{describeProp}},
  \code{\link{getDescriptionStatsBy}},
  \code{\link{getPvalWilcox}}
}
\concept{descriptive functions}
