% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aindex.R
\name{Aindex}
\alias{Aindex}
\title{R function for calculating the Hodder-Okell's A index of spatial association}
\usage{
Aindex(x, y, studyplot = NULL, B = 199, addmap = FALSE)
}
\arguments{
\item{x}{Point pattern (SpatialPointDataframe class).}

\item{y}{Point pattern (SpatialPointDataframe class).}

\item{studyplot}{Feature (of polygon type; SpatialPolygonsDataFrame class) representing the study
area; if not provided, the study area is internally worked out as the bounding polygon based on
the union the convex hulls of the x and y patterns. This is only used for visualization purpose,
should the user want to plot the two point patterns within the actual study area.}

\item{B}{Number of permutations (199 by default).}

\item{addmap}{FALSE (default) or TRUE if the user does not want or wants a map of the study area
and of the two patterns to be displayed.}
}
\value{
The function produces:\cr -an histogram showing the frequency distribution of the
 randomized A index, with vertical reference lines representing the 0.025th and 0.975th quantile
 of the distribution. A black dot represents the observed A index. At the bottom of the chart the
 randomized p values are reported;\cr -optionally (setting the 'addmap' parameter to TRUE), a map
 showing the point patterns (and the study area, if supplied).
}
\description{
The function allows to calculate the Hodder-Okell's A index of spatial association between the
features of two point patterns.\cr
}
\details{
The functions takes as input two point patterns (SpatialPointDataframe class) and calculate the A
index. Details about the latter are provided by:\cr Orton C. 1980, "Mathematics in Archeology",
Glasgow: William Collins Sons & Co Ltd, pp. 154-155\cr Blankholm P. 1990, "Intrasite spatial
Analysis in Theory and Practice", Aarhus: Aarhus University Press, pp. 130-135.\cr

The A index is about equal to 1 when the two patterns are randomly mingled; it is smaller than 1
when the two patterns are segregated; it is larger than 1 when the features of the two point
patterns tend to occur together. The computational details are provided by Blankholm's book cited
above (page 132).\cr

The significance of the A index is calculated via the randomized approach devised by:\cr Kintigh K
W. 1990, “Intrasite Spatial Analysis: A Commentary of Major Methids”. In Voorrips A, “Mathematics
and Information Science in Archaeology: A Flexible Framework”, Studies in Modern Archaeology 3:
165-200\cr

Given two patterns A and B being analysed, the procedure keeps the points location unchanged and
randomly assigns the points to either pattern. The random re-assignment is performed B times (199
by default) and each time the A index is calculated. One-tailed and two-tailed p values are
calculated following the procedure described by Baddeley et al., "Spatial Point Patterns.
Methodology and Applications with R", CRC Press 2016, p. 387.\cr
}
\examples{
# calculate the Hodder-Okell's A index for the two patterns, and plot the map
Aindex(springs, points, addmap=TRUE)

}
\seealso{
\code{\link{distRandSign}} , \code{\link{distCovarModel}} ,
 \code{\link{pointsCovarModel}}
}
\keyword{Aindex}
