% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Merge_methylation.R
\name{methyDiff}
\alias{methyDiff}
\title{Get methylation difference gene}
\usage{
methyDiff(
  cpgData,
  sampleGroup,
  combineMethod = RobustRankAggreg::rhoScores,
  missing_value = "knn",
  region = "Body",
  model = "cpg",
  adjust.method = "BH"
)
}
\arguments{
\item{cpgData}{data.frame of cpg beta value}

\item{sampleGroup}{vector of sample group}

\item{combineMethod}{method to combine the cpg pvalues}

\item{missing_value}{Method to  impute missing expression data, one of "zero" and "knn".}

\item{region}{region of genes, one of "Body", "TSS1500", "TSS200", "3'UTR", "1stExon", "5'UTR", and "IGR".}

\item{model}{if "cpg", step1: calculate difference cpgs; step2: calculate difference genes.
if "gene", step1: calculate the methylation level of genes; step2: calculate difference genes.}

\item{adjust.method}{character string specifying the method used to adjust p-values for multiple testing.
See \link{p.adjust} for possible values.}
}
\description{
Get methylation difference gene
}
