% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{get_gtf}
\alias{get_gtf}
\title{Download GTF File from the GENCODE Database}
\usage{
get_gtf(species, release_version, annotation_type, dest_folder)
}
\arguments{
\item{species}{A character string indicating the species. Supported values are:
\itemize{
\item "human"
\item "mouse"
}}

\item{release_version}{A character string specifying the release version. Options include:
\itemize{
\item "latest_release": Automatically fetches the latest release for the specified species.
\item "release_X": Specific human release (e.g., "release_47").
\item "release_MX": Specific mouse release (e.g., "release_M36").
}}

\item{annotation_type}{A character string specifying the annotation type. Valid options are:
\itemize{
\item "annotation.gtf.gz"
\item "basic.annotation.gtf.gz"
\item "chr_patch_hapl_scaff.annotation.gtf.gz"
\item "chr_patch_hapl_scaff.basic.annotation.gtf.gz"
\item "long_noncoding_RNAs.gtf.gz"
\item "primary_assembly.annotation.gtf.gz"
\item "primary_assembly.basic.annotation.gtf.gz"
\item "tRNAs.gtf.gz"
\item "polyAs.gtf.gz"
}}

\item{dest_folder}{A character string specifying the destination folder where the file will be downloaded. Defaults to the current working directory.}
}
\value{
A character string specifying the path to the downloaded GTF file.
}
\description{
Downloads a GTF file for a specified species, release version, and annotation type from the GENCODE database.
The file is saved to a user-specified directory or the current working directory by default.
}
\details{
The function dynamically determines the correct file URL based on the provided parameters and downloads the GTF file to the desired location.
If "latest_release" is specified for \code{release_version}, the function will first determine the latest available release using \code{get_latest_release()}.
}
\examples{
\donttest{
# Download the latest human GTF file with primary assembly annotations into a temp directory
temp_dir <- tempdir()
gtf_file <- get_gtf(
  species = "human",
  release_version = "latest_release",
  annotation_type = "primary_assembly.basic.annotation.gtf.gz",
  dest_folder = temp_dir
)
print(gtf_file)

# Download a specific mouse release with long noncoding RNA annotations into a temp directory
temp_dir <- tempdir()
gtf_file <- get_gtf(
  species = "mouse",
  release_version = "release_M36",
  annotation_type = "long_noncoding_RNAs.gtf.gz",
  dest_folder = temp_dir
)
print(gtf_file)
}

}
