% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carcass_persistence_figure_functions.R
\name{plot.cpmSet}
\alias{plot.cpmSet}
\title{Plot results of a set of CP models}
\usage{
\method{plot}{cpmSet}(x, specificModel = NULL, app = FALSE,
  cols = CPcols(), ...)
}
\arguments{
\item{x}{pk model set of class pkmSet}

\item{specificModel}{the name(s) or index number(s) of specific model(s) to 
restrict the plot}

\item{app}{logical indicating if the plot is for the app}

\item{cols}{named vector of the colors to use for the distributions}

\item{...}{to be passed down}
}
\description{
Produce a set of figures for a set of CP models, as fit by
  \code{\link{cpmSet}}
}
\examples{
  data(wind_RP)
  mod <- cpmSet(formula_l = l ~ Season, formula_s = s ~ Season,  
           data = wind_RP$CP, left = "LastPresent", right = "FirstAbsent")
 \donttest{plot(mod)}

}
