% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{gsc2tmod}
\alias{gsc2tmod}
\title{gsc2tmod}
\usage{
gsc2tmod(MODULES2GENES, MODULES = NULL, GENES = NULL)
}
\arguments{
\item{MODULES2GENES}{A named list of character vectors in which the vectors correspond to gene sets
and contain gene symbols (or other gene identifiers) and the names are the corresponding gene set
identifiers.}

\item{MODULES}{(optional) A data.frame containing an \code{ID} and a \code{Title} field
in the same order as the gene sets in \code{MODULES2GENES}. Furthermore, the row names should
(apparently) correspond to the IDs in the corresponding rows. If not provided, this will be generated
automatically.}

\item{GENES}{(optional) A data frame with gene metadata. Must contain an ID column. If not provided,
this will be generated automatically.}
}
\value{
Returns a \code{tmod} object if the \code{tmod} package version \code{'0.46.2'} or earlier is
installed. If the \code{tmod} package version '0.50.11' or later is installed, it returns a
\code{tmodGS} object instead.
}
\description{
Function to convert a GSC in the form of a named list of vectors containing gene symbols
to a object of class \code{tmod} which was used by the tmod prior to version \code{0.50.11}. This is
a wrapper for \code{\link[tmod]{makeTmod}()} from the \code{tmod} package.
}
\seealso{
\code{\link[=read_gmt]{read_gmt()}} \code{\link[=tmod2gsc]{tmod2gsc()}}
}
