% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.assoc.lsn.outcome.R
\name{grin.assoc.lsn.outcome}
\alias{grin.assoc.lsn.outcome}
\title{Associate Lesions with Clinical Outcomes}
\usage{
grin.assoc.lsn.outcome(
  lsn.mtx,
  clin.data,
  annotation.data,
  clinvars,
  covariate = NULL
)
}
\arguments{
\item{lsn.mtx}{Binary lesion matrix in which each type of lesions affecting certain gene is represented in a separate row for example ENSG00000148400_gain. If the gene is affected by this specific type of lesion, patient entry will be coded as 1 or 0 otherwisw. This matrix is the output of the prep.binary.lsn.mtx function.}

\item{clin.data}{Clinical data table in which the first column "ID" should has the patient ID.}

\item{annotation.data}{Gene annotation data either provided by the user or retrieved from ensembl BioMart database using get.ensembl.annotation function included in the GRIN2.0 library. Data.frame should has four columns: "gene" which is the ensembl ID of annotated genes, "chrom" which is the chromosome on which the gene is located, "loc.start" which is the gene start position, and "loc.end" the gene end position.}

\item{clinvars}{Clinical outcome variables of interest (survival variables such as EFS and OS should be first coded as survival objects using Surv function and added as new columns to the clinical data file, binary variables such as MRD should be coded as 0, 1).}

\item{covariate}{Covariates that the model will adjust for if any.}
}
\value{
Function returns a results table that has gene annotation data, and multiple columns showing results of the logistic regression model for association with binary variables such as MRD that include odds.ratio, lower and upper 95 confidence interval (CI), model p and FDR adjusted q values, in addition to the number of patients with/without lesion who experienced or did not experience the event. Results table will also include results of COXPH models for association between lesions with survival variables such as EFS, OS that include COXPH hazard ratio, lower and upper 95 CI, model p and FDR adjusted q values, in addition to the number of patients with/without the lesion who experienced or did not experience the event.
}
\description{
The function run association analysis between the binary lesion matrix (output of prep.binary.lsn.mtx function) and clinical outcomes of interest such as Minimal Residual Disease (MRD), Event-free Survival (EFS) and Overall Survival (OS), etc...
}
\details{
The function run association analysis between the binary lesion matrix in which each type of lesions affecting certain gene is represented in a separate row (output of prep.binary.lsn.mtx function) and clinical outcomes.Function will run logistic regression models for association between each gene-lesion pair with numeric variables such as MRD that should be coded as 0 if the patient is MRD-negative and 1 if the patient is MRD positive. Function will also run COX-Proportional hazard models for association between lesions and survival objects such as Event-free survival (EFS) and oveall survival (OS). EFS and OS should be first coded as survival objects using Surv function and added as new columns to the clinical data file. If specified, the models can be also adjusted for one or a group of covariates such as risk group assignment, gender, age, etc...
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)
data(clin.data)

# prepare lesion data and find gene lesion overlaps:
gene.lsn=prep.gene.lsn.data(lesion.data, hg19.gene.annotation)
gene.lsn.overlap= find.gene.lsn.overlaps(gene.lsn)

# Prepare a binary lesion matrix for genes affected by a certain type of lesion in at least
# 5 subjects using prep.binary.lsn.mtx function:
lsn.binary.mtx=prep.binary.lsn.mtx(gene.lsn.overlap, min.ngrp=5)

# Prepare EFS and OS survival objects and add two new columns to the clinical data file:
library(survival)
clin.data$EFS <- Surv(clin.data$efs.time, clin.data$efs.censor)
clin.data$OS <- Surv(clin.data$os.time, clin.data$os.censor)
# define clinical outcome variables to be included in the analysis:
clinvars=c("MRD.binary", "EFS", "OS")

# Run association analysis between lesions in the binary lesion matrix and clinical variables
# in the clinvars object:
assc.outcomes=grin.assoc.lsn.outcome(lsn.binary.mtx,
                                     clin.data,
                                     hg19.gene.annotation,
                                     clinvars)

# to adjust the models for one or a group of covariates, user can specify one or a group
# of covariates using the 'covariate' argument.
}
\references{
Andersen, P. and Gill, R. (1982). Cox's regression model for counting processes, a large sample study.

Therneau, T., Grambsch, P. (2000) Modeling Survival Data: Extending the Cox Model.

Dobson, A. J. (1990) An Introduction to Generalized Linear Models.
}
\seealso{
\code{\link[stats:glm]{stats::glm()}}, \code{\link[survival:coxph]{survival::coxph()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
