% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual_data_TN.R
\docType{data}
\name{annual_data_TN}
\alias{annual_data_TN}
\title{Annual data TN}
\format{
A data frame with 14 variables:
\describe{
  \item{\code{BasinID}}{integer. The basin unique identifier.}
  \item{\code{YearValue}}{integer. The year for which data are defined.}
  \item{\code{HydroID}}{integer positive. Unique catchment identifier.}
  \item{\code{NextDownID}}{integer. Unique identifier of the catchment to
  which the catchment goes.}
  \item{\code{Atm}}{double. Annual nitrogen deposition from atmosphere
  (ton/yr).}
  \item{\code{Min}}{double. Annual amount of nitrogen from mineral
  fertilisers (ton/yr).}
  \item{\code{Man}}{double. Annual amount of nitrogen in manure fertilisers
  (ton/yr).}
  \item{\code{Fix}}{double. Annual amount of nitrogen fixation by leguminous
  crops and fodder (ton/yr).}
  \item{\code{Soil}}{double. Annual amount of nitrogen fixation by bacteria
  in soils (ton/yr).}
  \item{\code{Sd}}{double. Nitrogen input from scattered dwellings (ton/yr).}
  \item{\code{Ps}}{double. Nitrogen input from point sources (ton/yr).}
  \item{\code{YearlyMass}}{double. Observed annual total nitrogen load
  (TN ton/yr) from monitoring station data.}
  \item{\code{ForestFraction}}{double. Non-agricultural land cover in the
  catchment (fraction).}
  \item{\code{InvNrmRain}}{double. Inverse of normalized rainfall.}
}
}
\usage{
annual_data_TN
}
\description{
Defines the sources of nutrient (nitrogen) for each year and catchments.
}
\keyword{datasets}
